/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileWrapper");
    public static final Key<NotNullFunction<InspectionProfileWrapper, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    protected final InspectionProfile myProfile;
    private static boolean alreadyChecked;

    public InspectionProfileWrapper(@NotNull InspectionProfile profile) {
        this.myProfile = profile;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
        return this.myProfile.getInspectionTools(element);
    }

    public static void checkInspectionsDuplicates(@NotNull InspectionToolWrapper[] toolWrappers) {
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqTools = new THashSet(toolWrappers.length);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public String getName() {
        return this.myProfile.getName();
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        return this.myProfile.isToolEnabled(key, element);
    }

    public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
        return this.myProfile.getInspectionTool(shortName, element);
    }

    public void init(@NotNull Project project2) {
        List profileEntries = this.myProfile.getAllEnabledInspectionTools(project2);
        for (Tools profileEntry : profileEntries) {
            for (ScopeToolState toolState : profileEntry.getTools()) {
                toolState.getTool().projectOpened(project2);
            }
        }
    }

    public void cleanup(@NotNull Project project2) {
        this.myProfile.cleanup(project2);
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        return this.myProfile;
    }
}

