/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml"), @Storage(value="other.xml", deprecated=true)}, additionalExportFile="inspection")
public class InspectionProfileManagerImpl
extends InspectionProfileManager
implements SeverityProvider,
PersistentStateComponent<Element> {
    private final InspectionToolRegistrar myRegistrar;
    private final SchemesManager<Profile, InspectionProfileImpl> mySchemeManager;
    private final AtomicBoolean myProfilesAreInitialized = new AtomicBoolean(false);
    private final SeverityRegistrar mySeverityRegistrar;
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProfileManager");
    private volatile boolean LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();

    public static InspectionProfileManagerImpl getInstanceImpl() {
        return (InspectionProfileManagerImpl)ServiceManager.getService(InspectionProfileManager.class);
    }

    public InspectionProfileManagerImpl(@NotNull InspectionToolRegistrar registrar, @NotNull SchemesManagerFactory schemesManagerFactory, @NotNull MessageBus messageBus) {
        this.myRegistrar = registrar;
        InspectionProfileManagerImpl.registerProvidedSeverities();
        this.mySchemeManager = schemesManagerFactory.create("inspection", (SchemeProcessor)new SchemeProcessor<InspectionProfileImpl>(){

            @NotNull
            public InspectionProfileImpl readScheme(@NotNull Element element) {
                final InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(element), InspectionProfileManagerImpl.this.myRegistrar, (ProfileManager)InspectionProfileManagerImpl.this);
                try {
                    profile.readExternal(element);
                }
                catch (Exception ignored) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, profile.getName()}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                        }
                    }, ModalityState.NON_MODAL);
                }
                return profile;
            }

            @NotNull
            public SchemeProcessor.State getState(@NotNull InspectionProfileImpl scheme) {
                return scheme.isProjectLevel() ? SchemeProcessor.State.NON_PERSISTENT : (scheme.wasInitialized() ? SchemeProcessor.State.POSSIBLY_CHANGED : SchemeProcessor.State.UNCHANGED);
            }

            public Element writeScheme(@NotNull InspectionProfileImpl scheme) {
                Element root = new Element("inspections");
                root.setAttribute("profile_name", scheme.getName());
                scheme.serializeInto(root, false);
                return root;
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                InspectionProfileManagerImpl.updateProfileImpl(scheme);
                InspectionProfileManagerImpl.this.fireProfileChanged(scheme);
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme) {
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onCurrentSchemeChanged(@Nullable Scheme oldScheme) {
                Profile current = (Profile)InspectionProfileManagerImpl.this.mySchemeManager.getCurrentScheme();
                if (current != null) {
                    InspectionProfileManagerImpl.this.fireProfileChanged((Profile)oldScheme, current, null);
                }
                InspectionProfileManagerImpl.onProfilesChanged();
            }
        });
        this.mySeverityRegistrar = new SeverityRegistrar(messageBus);
    }

    @NotNull
    private InspectionProfileImpl createSampleProfile(@NotNull String name, InspectionProfileImpl baseProfile) {
        return new InspectionProfileImpl(name, InspectionToolRegistrar.getInstance(), (ProfileManager)this, baseProfile);
    }

    public static void registerProvidedSeverities() {
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = t.getSeverity(null);
                SeverityRegistrar.registerStandard(t, highlightSeverity);
                TextAttributesKey attributesKey = t.getAttributesKey();
                Icon icon = t instanceof HighlightInfoType.Iconable ? ((HighlightInfoType.Iconable)((Object)t)).getIcon() : null;
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)attributesKey, (Icon)icon);
            }
        }
    }

    @NotNull
    public Collection<Profile> getProfiles() {
        this.initProfiles();
        return this.mySchemeManager.getAllSchemes();
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    @Override
    public void initProfiles() {
        if (this.myProfilesAreInitialized.getAndSet(true)) {
            if (this.mySchemeManager.getAllSchemes().isEmpty()) {
                this.createDefaultProfile();
            }
            return;
        }
        if (!this.LOAD_PROFILES) {
            return;
        }
        this.mySchemeManager.loadSchemes();
        if (this.mySchemeManager.getAllSchemes().isEmpty()) {
            this.createDefaultProfile();
        }
    }

    private void createDefaultProfile() {
        InspectionProfileImpl defaultProfile = this.createSampleProfile("Default", InspectionProfileImpl.getDefaultProfile());
        this.addProfile(defaultProfile);
    }

    @Override
    public Profile loadProfile(@NotNull String path) throws IOException, JDOMException {
        final File file2 = new File(path);
        if (file2.exists()) {
            try {
                return InspectionProfileLoadUtil.load(file2, this.myRegistrar, (ProfileManager)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (JDOMException e) {
                throw e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file2}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    public void updateProfile(@NotNull Profile profile) {
        this.mySchemeManager.addScheme((Scheme)profile);
        InspectionProfileManagerImpl.updateProfileImpl(profile);
    }

    private static void updateProfileImpl(@NotNull Profile profile) {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            InspectionProjectProfileManager.getInstance(project2).initProfileWrapper(profile);
        }
    }

    @Override
    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    @Override
    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.mySeverityRegistrar.writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.mySeverityRegistrar.readExternal(state);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    public InspectionProfileImpl createProfile() {
        return this.createSampleProfile("Default", InspectionProfileImpl.getDefaultProfile());
    }

    public void setRootProfile(@Nullable String profileName) {
        this.mySchemeManager.setCurrentSchemeName(profileName);
    }

    public Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        Profile found = (Profile)this.mySchemeManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getRootProfile();
        }
        return null;
    }

    @NotNull
    public Profile getRootProfile() {
        this.initProfiles();
        Profile current = (Profile)this.mySchemeManager.getCurrentScheme();
        if (current != null) {
            return current;
        }
        Collection<Profile> profiles = this.getProfiles();
        if (profiles.isEmpty()) {
            return this.createSampleProfile("Default", null);
        }
        return profiles.iterator().next();
    }

    @NotNull
    public String getRootProfileName() {
        return (String)ObjectUtils.chooseNotNull((Object)this.mySchemeManager.getCurrentSchemeName(), (Object)"Default");
    }

    public void deleteProfile(@NotNull String profile) {
        Profile found = (Profile)this.mySchemeManager.findSchemeByName(profile);
        if (found != null) {
            this.mySchemeManager.removeScheme((Scheme)found);
        }
    }

    public void addProfile(@NotNull Profile profile) {
        this.mySchemeManager.addScheme((Scheme)profile);
    }

    @NotNull
    public String[] getAvailableProfileNames() {
        return ArrayUtil.toStringArray((Collection)this.mySchemeManager.getAllSchemeNames());
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        return this.getProfile(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onProfilesChanged() {
        for (final Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            HighlightingSettingsPerFile highlightingSettingsPerFile = HighlightingSettingsPerFile.getInstance(project2);
            synchronized (highlightingSettingsPerFile) {
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!project2.isDisposed()) {
                        DaemonListeners.getInstance(project2).updateStatusBar();
                    }
                }
            });
        }
    }
}

