/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();
    private GlobalInspectionContextImpl myGlobalInspectionContext;

    public InspectionManagerEx(final Project project2) {
        super(project2);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                return ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project2);
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                return contentManager;
            }
        };
    }

    @Nullable
    public static SuppressIntentionAction[] getSuppressActions(@NotNull InspectionToolWrapper toolWrapper) {
        Language language;
        InspectionProfileEntry tool = toolWrapper.getTool();
        if (tool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)tool).getSuppressActions(null);
        }
        ArrayList<SuppressQuickFix> actions = new ArrayList<SuppressQuickFix>(Arrays.asList(tool.getBatchSuppressActions(null)));
        if (actions.isEmpty() && (language = Language.findLanguageByID((String)toolWrapper.getLanguage())) != null) {
            List suppressors = LanguageInspectionSuppressors.INSTANCE.allForLanguage(language);
            for (InspectionSuppressor suppressor : suppressors) {
                SuppressQuickFix[] suppressActions = suppressor.getSuppressActions(null, toolWrapper.getID());
                Collections.addAll(actions, suppressActions);
            }
        }
        return (SuppressIntentionAction[])ContainerUtil.map2Array(actions, SuppressIntentionAction.class, (Function)new Function<LocalQuickFix, SuppressIntentionAction>(){

            public SuppressIntentionAction fun(LocalQuickFix fix) {
                return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)fix);
            }
        });
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl inspectionContext;
        if (reuse) {
            if (this.myGlobalInspectionContext == null) {
                this.myGlobalInspectionContext = inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
            } else {
                inspectionContext = this.myGlobalInspectionContext;
            }
        } else {
            inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        }
        this.myRunningContexts.add(inspectionContext);
        return inspectionContext;
    }

    public void setProfile(@NotNull String name) {
        this.myCurrentProfileName = name;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        return this.myRunningContexts;
    }

    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        return this.myContentManager;
    }
}

