/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalDescriptorsUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.SequentialCleanupTask;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Inspection Results", (String)ToolWindowId.INSPECTION);
    private final NotNullLazyValue<ContentManager> myContentManager;
    private InspectionResultsView myView;
    private Content myContent;
    @NotNull
    private AnalysisUIOptions myUIOptions;
    private static final String EXPLODED_AAR = "exploded-aar";
    private static final PsiFile TOMBSTONE = PsiUtilCore.NULL_PSI_FILE;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = new TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement>(){

        public RefElement fun(LocalInspectionTool tool, PsiElement elt, GlobalInspectionContext context) {
            PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elt, (Class[])new Class[]{PsiFile.class});
            RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
            if (refElement == null && problemElement != null) {
                refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context);
            }
            return refElement;
        }
    };
    private final ConcurrentMap<InspectionToolWrapper, InspectionToolPresentation> myPresentationMap = ContainerUtil.newConcurrentMap();

    public GlobalInspectionContextImpl(@NotNull Project project2, @NotNull NotNullLazyValue<ContentManager> contentManager) {
        super(project2);
        this.myUIOptions = AnalysisUIOptions.getInstance(project2).copy();
        this.myContentManager = contentManager;
    }

    @NotNull
    private ContentManager getContentManager() {
        return (ContentManager)this.myContentManager.getValue();
    }

    public synchronized void addView(@NotNull InspectionResultsView view, @NotNull String title) {
        if (this.myContent != null) {
            return;
        }
        ((ContentManager)this.myContentManager.getValue()).addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == GlobalInspectionContextImpl.this.myContent) {
                    if (GlobalInspectionContextImpl.this.myView != null) {
                        GlobalInspectionContextImpl.this.close(false);
                    }
                    GlobalInspectionContextImpl.this.myContent = null;
                }
            }
        });
        this.myView = view;
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        this.myContent.setDisposer((Disposable)this.myView);
        ContentManager contentManager = this.getContentManager();
        contentManager.addContent(this.myContent);
        contentManager.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(ToolWindowId.INSPECTION).activate(null);
    }

    public void addView(@NotNull InspectionResultsView view) {
        this.addView(view, view.getCurrentProfileName() == null ? InspectionsBundle.message((String)"inspection.results.title", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.results.for.profile.toolwindow.title", (Object[])new Object[]{view.getCurrentProfileName()}));
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope) {
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope);
    }

    public void launchInspectionsOffline(@NotNull AnalysisScope scope, @Nullable String outputPath, boolean runGlobalToolsOnly, @NotNull List<File> inspectionsResults) {
        this.performInspectionsWithProgressAndExportResults(scope, runGlobalToolsOnly, true, outputPath, inspectionsResults);
    }

    public void performInspectionsWithProgressAndExportResults(final @NotNull AnalysisScope scope, final boolean runGlobalToolsOnly, final boolean isOfflineInspections, final @Nullable String outputPath, final @NotNull List<File> inspectionsResults) {
        this.cleanupTools();
        this.setCurrentScope(scope);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                DefaultInspectionToolPresentation.setOutputPath(outputPath);
                try {
                    GlobalInspectionContextImpl.this.performInspectionsWithProgress(scope, runGlobalToolsOnly, isOfflineInspections);
                    GlobalInspectionContextImpl.this.exportResults(inspectionsResults, outputPath);
                }
                finally {
                    DefaultInspectionToolPresentation.setOutputPath(null);
                }
            }
        };
        if (isOfflineInspections) {
            ApplicationManager.getApplication().runReadAction(action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResults(@NotNull List<File> inspectionsResults, @Nullable String outputPath) {
        File file2;
        String ext = ".xml";
        HashMap globalTools = new HashMap();
        for (Map.Entry entry : this.myTools.entrySet()) {
            Tools sameTools = (Tools)entry.getValue();
            boolean hasProblems = false;
            String toolName = (String)entry.getKey();
            if (sameTools != null) {
                for (ScopeToolState toolDescr : sameTools.getTools()) {
                    InspectionToolWrapper toolWrapper = toolDescr.getTool();
                    if (toolWrapper instanceof LocalInspectionToolWrapper) {
                        hasProblems = new File(outputPath, toolName + ".xml").exists();
                        continue;
                    }
                    InspectionToolPresentation presentation = this.getPresentation(toolWrapper);
                    presentation.updateContent();
                    if (!presentation.hasReportedProblems()) continue;
                    Element root = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
                    globalTools.put(root, sameTools);
                    LOG.assertTrue(!hasProblems, (Object)toolName);
                    break;
                }
            }
            if (!hasProblems) continue;
            try {
                new File(outputPath).mkdirs();
                file2 = new File(outputPath, toolName + ".xml");
                inspectionsResults.add(file2);
                FileUtil.writeToFile((File)file2, (byte[])("</" + InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]) + ">").getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.getRefManager().iterate(new RefVisitor((Map)globalTools){
            final /* synthetic */ Map val$globalTools;
            {
                this.val$globalTools = map;
            }

            public void visitElement(@NotNull RefEntity refEntity) {
                for (Map.Entry entry : this.val$globalTools.entrySet()) {
                    Tools tools = (Tools)entry.getValue();
                    Element element = (Element)entry.getKey();
                    for (ScopeToolState state : tools.getTools()) {
                        try {
                            InspectionToolWrapper toolWrapper = state.getTool();
                            InspectionToolPresentation presentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                            presentation.exportResults(element, refEntity);
                        }
                        catch (Throwable e) {
                            LOG.error("Problem when exporting: " + refEntity.getExternalName(), e);
                        }
                    }
                }
            }
        });
        for (Map.Entry entry : globalTools.entrySet()) {
            String toolName = ((Tools)entry.getValue()).getShortName();
            Element element = (Element)entry.getKey();
            element.setAttribute("is_local_tool", Boolean.toString(false));
            org.jdom.Document doc = new org.jdom.Document(element);
            PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePaths(doc.getRootElement());
            try {
                new File(outputPath).mkdirs();
                file2 = new File(outputPath, toolName + ".xml");
                inspectionsResults.add(file2);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), CharsetToolkit.UTF8_CHARSET);){
                    JDOMUtil.writeDocument((org.jdom.Document)doc, (Writer)writer, (String)"\n");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void ignoreElement(@NotNull InspectionProfileEntry tool, @NotNull PsiElement element) {
        RefElement refElement = this.getRefManager().getReference(element);
        Tools tools = (Tools)this.myTools.get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                this.ignoreElementRecursively(toolWrapper, (RefEntity)refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    private void ignoreElementRecursively(@NotNull InspectionToolWrapper toolWrapper, RefEntity refElement) {
        if (refElement != null) {
            InspectionToolPresentation presentation = this.getPresentation(toolWrapper);
            presentation.ignoreCurrentElement(refElement);
            List children2 = refElement.getChildren();
            if (children2 != null) {
                for (RefEntity child : children2) {
                    this.ignoreElementRecursively(toolWrapper, child);
                }
            }
        }
    }

    @NotNull
    public AnalysisUIOptions getUIOptions() {
        return this.myUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.myUIOptions.SPLITTER_PROPORTION = proportion;
    }

    @NotNull
    public ToggleAction createToggleAutoscrollAction() {
        return this.myUIOptions.getAutoScrollToSourceHandler().createToggleAction();
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope) {
        this.myUIOptions = AnalysisUIOptions.getInstance(this.getProject()).copy();
        this.myView = new InspectionResultsView(this.getProject(), this.getCurrentProfile(), scope, this, new InspectionRVContentProviderImpl(this.getProject()));
        super.launchInspections(scope);
    }

    @Override
    @NotNull
    protected PerformInBackgroundOption createOption() {
        return new PerformAnalysisInBackgroundOption(this.getProject());
    }

    @Override
    protected void notifyInspectionsFinished(final AnalysisScope scope) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("Code inspection finished");
                if (GlobalInspectionContextImpl.this.myView != null) {
                    if (!GlobalInspectionContextImpl.this.myView.update() && !GlobalInspectionContextImpl.this.getUIOptions().SHOW_ONLY_DIFF) {
                        NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope.getFileCount(), scope.getDisplayName()}), MessageType.INFO).notify(GlobalInspectionContextImpl.this.getProject());
                        GlobalInspectionContextImpl.this.close(true);
                    } else {
                        GlobalInspectionContextImpl.this.addView(GlobalInspectionContextImpl.this.myView);
                    }
                }
            }
        });
    }

    private static boolean isIgnoredFile(@NotNull PsiFile psiFile) {
        for (VirtualFile file2 = psiFile.getVirtualFile(); file2 != null; file2 = file2.getParent()) {
            if (!EXPLODED_AAR.equals(file2.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            throw new IncorrectOperationException("Must be run under progress");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isDispatchThread()) {
            throw new IncorrectOperationException("Must not start inspections from within EDT");
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within write action");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within global read action");
        }
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.getProject());
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        final ArrayList<Tools> localTools = new ArrayList<Tools>();
        final ArrayList<Tools> globalSimpleTools = new ArrayList<Tools>();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        this.runGlobalTools(scope, inspectionManager, globalTools, isOfflineInspections);
        if (runGlobalToolsOnly) {
            return;
        }
        THashSet localScopeFiles = scope.toSearchScope() instanceof LocalSearchScope ? new THashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)this.getPresentation(toolWrapper));
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        final Map<String, InspectionToolWrapper> map = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        ArrayBlockingQueue<PsiFile> filesToInspect = new ArrayBlockingQueue<PsiFile>(1000);
        LinkedBlockingQueue filesFailedToInspect = new LinkedBlockingQueue();
        Future<?> future2 = this.startIterateScopeInBackground(scope, (Collection<VirtualFile>)localScopeFiles, headlessEnvironment, filesToInspect, progressIndicator);
        Processor<PsiFile> processor2 = new Processor<PsiFile>(){

            public boolean process(final PsiFile file2) {
                ProgressManager.checkCanceled();
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!file2.isValid()) {
                            return;
                        }
                        GlobalInspectionContextImpl.this.inspectFile(file2, inspectionManager, localTools, globalSimpleTools, map);
                    }
                })) {
                    throw new ProcessCanceledException();
                }
                return true;
            }
        };
        try {
            while (true) {
                Disposable disposable = Disposer.newDisposable();
                SensitiveProgressWrapper wrapper = new SensitiveProgressWrapper(progressIndicator);
                wrapper.start();
                ProgressIndicatorUtils.forceWriteActionPriority(wrapper, disposable);
                try {
                    ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(filesToInspect, filesFailedToInspect, wrapper, TOMBSTONE, processor2);
                }
                catch (ProcessCanceledException ignored) {
                    progressIndicator.checkCanceled();
                    assert (!ApplicationManager.getApplication().isReadAccessAllowed());
                    assert (!ApplicationManager.getApplication().isDispatchThread());
                    ApplicationManager.getApplication().runReadAction(EmptyRunnable.getInstance());
                    continue;
                }
                finally {
                    Disposer.dispose((Disposable)disposable);
                    continue;
                }
                break;
            }
        }
        finally {
            filesToInspect.clear();
            try {
                future2.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Thread dump: \n" + ThreadDumper.dumpThreadsToString(), (Throwable)e);
            }
        }
        progressIndicator.checkCanceled();
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map);
            tool.inspectionFinished(inspectionManager, (GlobalInspectionContext)this, problemDescriptionProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inspectFile(final @NotNull PsiFile file2, final @NotNull InspectionManager inspectionManager, @NotNull List<Tools> localTools, @NotNull List<Tools> globalSimpleTools, final @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        if (GlobalInspectionContextImpl.isIgnoredFile(file2)) {
            return true;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
        if (document == null) {
            return true;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        String url = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
        this.incrementJobDoneAmount(this.getStdJobDescriptors().LOCAL_ANALYSIS, url);
        LocalInspectionsPass pass = new LocalInspectionsPass(file2, document, 0, file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
        try {
            List<LocalInspectionToolWrapper> lTools = GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2);
            pass.doInspectInBatch(this, inspectionManager, lTools);
            List tools = GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2);
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(tools, this.myProgressIndicator, false, new Processor<GlobalInspectionToolWrapper>(){

                public boolean process(GlobalInspectionToolWrapper toolWrapper) {
                    GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                    ProblemsHolder holder = new ProblemsHolder(inspectionManager, file2, false);
                    ProblemDescriptionsProcessor problemDescriptionProcessor = GlobalInspectionContextImpl.this.getProblemDescriptionProcessor(toolWrapper, wrappersMap);
                    tool.checkFile(file2, inspectionManager, holder, (GlobalInspectionContext)GlobalInspectionContextImpl.this, problemDescriptionProcessor);
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                    LocalDescriptorsUtil.addProblemDescriptors(holder.getResults(), false, GlobalInspectionContextImpl.this, null, (TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement>)CONVERT, toolPresentation);
                    return true;
                }
            });
        }
        catch (ProcessCanceledException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            LOG.error("In file: " + file2, cause);
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("In file: " + file2.getName(), e);
        }
        finally {
            InjectedLanguageManager.getInstance((Project)this.getProject()).dropFileCaches(file2);
        }
        return true;
    }

    @NotNull
    private Future<?> startIterateScopeInBackground(final @NotNull AnalysisScope scope, final @Nullable Collection<VirtualFile> localScopeFiles, final boolean headlessEnvironment, final @NotNull BlockingQueue<PsiFile> outFilesToInspect, final @NotNull ProgressIndicator progressIndicator) {
        return ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()).getFileIndex();
                    scope.accept((Processor)new Processor<VirtualFile>((FileIndex)fileIndex){
                        final /* synthetic */ FileIndex val$fileIndex;
                        {
                            this.val$fileIndex = fileIndex;
                        }

                        public boolean process(final VirtualFile file2) {
                            progressIndicator.checkCanceled();
                            if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || !this.val$fileIndex.isInContent(file2)) {
                                return true;
                            }
                            final PsiFile[] psiFile = new PsiFile[1];
                            Document document = (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

                                public Document compute() {
                                    Document document;
                                    if (GlobalInspectionContextImpl.this.getProject().isDisposed()) {
                                        throw new ProcessCanceledException();
                                    }
                                    PsiFile psi = PsiManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()).findFile(file2);
                                    Document document2 = document = psi == null ? null : GlobalInspectionContextImpl.this.shouldProcess(psi, headlessEnvironment, localScopeFiles);
                                    if (document != null) {
                                        psiFile[0] = psi;
                                    }
                                    return document;
                                }
                            });
                            if (document != null && psiFile[0] != null) {
                                try {
                                    LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed());
                                    outFilesToInspect.put(psiFile[0]);
                                }
                                catch (InterruptedException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                }
                finally {
                    try {
                        outFilesToInspect.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    private Document shouldProcess(@NotNull PsiFile file2, boolean headlessEnvironment, @Nullable Collection<VirtualFile> localScopeFiles) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (GlobalInspectionContextImpl.isBinary(file2)) {
            return null;
        }
        if (this.myView == null && !headlessEnvironment) {
            throw new ProcessCanceledException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running local inspections on " + virtualFile.getPath());
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile)) {
            return null;
        }
        if (localScopeFiles != null && !localScopeFiles.add(virtualFile)) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private void runGlobalTools(final @NotNull AnalysisScope scope, final @NotNull InspectionManager inspectionManager, @NotNull List<Tools> globalTools, boolean isOfflineInspections) {
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed() || isOfflineInspections, (Object)"Must not run under read action, too unresponsive");
        final ArrayList needRepeatSearchRequest = new ArrayList();
        final boolean canBeExternalUsages = scope.getScopeType() != 1 || !scope.isIncludeTestSource();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                final InspectionToolWrapper toolWrapper = state.getTool();
                final GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                final InspectionToolPresentation toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            ((RefManagerImpl)this.getRefManager()).findAllDeclarations();
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            tool.runInspection(scope, inspectionManager, (GlobalInspectionContext)GlobalInspectionContextImpl.this, (ProblemDescriptionsProcessor)toolPresentation);
                            if ((canBeExternalUsages || tool.getAdditionalJobs() != null) && tool.queryExternalUsagesRequests(inspectionManager, (GlobalInspectionContext)GlobalInspectionContextImpl.this, (ProblemDescriptionsProcessor)toolPresentation)) {
                                needRepeatSearchRequest.add(toolWrapper);
                            }
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            try {
                extension.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<Tools> globalTools, @NotNull List<Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] larray;
        for (Tools tool : larray = localTools.toArray(new Tools[localTools.size()])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)localTool).getInspectionForBatchShortName();
            InspectionProfile currentProfile = this.getCurrentProfile();
            if (currentProfile == null) {
                batchInspection = null;
            } else {
                InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
                InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            }
            if (batchInspection == null || this.myTools.containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ToolsImpl newTool = new ToolsImpl(batchInspection, batchInspection.getDefaultLevel(), true, true);
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.myTools.put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    @NotNull
    private static <T extends InspectionToolWrapper> List<T> getWrappersFromTools(@NotNull List<Tools> localTools, @NotNull PsiFile file2) {
        ArrayList<InspectionToolWrapper> lTools = new ArrayList<InspectionToolWrapper>();
        for (Tools tool : localTools) {
            InspectionToolWrapper enabledTool = tool.getEnabledTool((PsiElement)file2);
            if (enabledTool == null) continue;
            lTools.add(enabledTool);
        }
        return lTools;
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        return new ProblemDescriptionsProcessor(){

            @Nullable
            public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                return new CommonProblemDescriptor[0];
            }

            public void ignoreElement(@NotNull RefEntity refEntity) {
            }

            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor)) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    GlobalInspectionToolWrapper globalInspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                }
            }

            public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                return null;
            }
        };
    }

    @NotNull
    private static Map<String, InspectionToolWrapper> getInspectionWrappersMap(@NotNull List<Tools> tools) {
        HashMap name2Inspection = new HashMap(tools.size());
        for (Tools tool : tools) {
            InspectionToolWrapper toolWrapper = tool.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        return name2Inspection;
    }

    @Override
    public void close(boolean noSuspisiousCodeFound) {
        if (!noSuspisiousCodeFound && (this.myView == null || this.myView.isRerun())) {
            return;
        }
        AnalysisUIOptions.getInstance(this.getProject()).save(this.myUIOptions);
        if (this.myContent != null) {
            ContentManager contentManager = this.getContentManager();
            contentManager.removeContent(this.myContent, true);
        }
        this.myView = null;
        super.close(noSuspisiousCodeFound);
    }

    @Override
    public void cleanup() {
        ((InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject())).closeRunningContext(this);
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                this.getPresentation(toolWrapper).finalCleanup();
            }
        }
        super.cleanup();
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.updateView(false);
        }
    }

    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionToolPresentation presentation = (InspectionToolPresentation)this.myPresentationMap.get(toolWrapper);
        if (presentation == null) {
            String presentationClass = StringUtil.notNullize((String)(toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation), (String)DefaultInspectionToolPresentation.class.getName());
            try {
                Constructor<?> constructor = Class.forName(presentationClass).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class);
                presentation = (InspectionToolPresentation)constructor.newInstance(new Object[]{toolWrapper, this});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
            presentation = (InspectionToolPresentation)ConcurrencyUtil.cacheOrGet(this.myPresentationMap, (Object)toolWrapper, (Object)presentation);
        }
        return presentation;
    }

    @Override
    public void codeCleanup(final @NotNull Project project2, final @NotNull AnalysisScope scope, final @NotNull InspectionProfile profile, final @Nullable String commandName, final @Nullable Runnable postRunnable, boolean modal) {
        Object task = modal ? new Task.Modal(project2, "Inspect code...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextImpl.this.cleanup(scope, profile, project2, postRunnable, commandName);
            }
        } : new Task.Backgroundable(project2, "Inspect code...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextImpl.this.cleanup(scope, profile, project2, postRunnable, commandName);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void cleanup(final @NotNull AnalysisScope scope, @NotNull InspectionProfile profile, final @NotNull Project project2, final @Nullable Runnable postRunnable, final @Nullable String commandName) {
        PsiElement[] elements;
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final ArrayList lTools = new ArrayList();
        final LinkedHashMap results = new LinkedHashMap();
        final SearchScope searchScope = scope.toSearchScope();
        final TextRange range = searchScope instanceof LocalSearchScope ? ((elements = ((LocalSearchScope)searchScope).getScope()).length == 1 ? (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TextRange>(){

            public TextRange compute() {
                return elements[0].getTextRange();
            }
        }) : null) : null;
        final List inspectionTools = ContainerUtil.filter((Collection)profile.getAllEnabledInspectionTools(project2), (Condition)new Condition<Tools>(){

            public boolean value(Tools tools) {
                assert (tools != null);
                return tools.getTool().getTool() instanceof CleanupLocalInspectionTool;
            }
        });
        scope.accept(new PsiElementVisitor(){
            private int myCount;

            public void visitFile(PsiFile file2) {
                if (progressIndicator != null) {
                    progressIndicator.setFraction((double)(++this.myCount) / (double)fileCount);
                }
                if (GlobalInspectionContextImpl.isBinary(file2)) {
                    return;
                }
                for (Tools tools : inspectionTools) {
                    InspectionToolWrapper tool = tools.getEnabledTool((PsiElement)file2);
                    if (!(tool instanceof LocalInspectionToolWrapper)) continue;
                    lTools.add((LocalInspectionToolWrapper)tool);
                    tool.initialize((GlobalInspectionContext)GlobalInspectionContextImpl.this);
                }
                if (!lTools.isEmpty()) {
                    final LocalInspectionsPass pass = new LocalInspectionsPass(file2, PsiDocumentManager.getInstance((Project)project2).getDocument(file2), range != null ? range.getStartOffset() : 0, range != null ? range.getEndOffset() : file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            pass.doInspectInBatch(GlobalInspectionContextImpl.this, InspectionManager.getInstance((Project)project2), lTools);
                        }
                    };
                    ApplicationManager.getApplication().runReadAction(runnable2);
                    List<HighlightInfo> infos = pass.getInfos();
                    if (searchScope instanceof LocalSearchScope) {
                        Iterator<HighlightInfo> iterator = infos.iterator();
                        while (iterator.hasNext()) {
                            HighlightInfo info = iterator.next();
                            TextRange infoRange = new TextRange(info.getStartOffset(), info.getEndOffset());
                            if (((LocalSearchScope)searchScope).containsRange(file2, infoRange)) continue;
                            iterator.remove();
                        }
                    }
                    if (!infos.isEmpty()) {
                        results.put(file2, infos);
                    }
                }
            }
        });
        if (results.isEmpty()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (commandName != null) {
                        NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope.getFileCount(), scope.getDisplayName()}), MessageType.INFO).notify(GlobalInspectionContextImpl.this.getProject());
                    }
                    if (postRunnable != null) {
                        postRunnable.run();
                    }
                }
            });
            return;
        }
        String title = "Code Cleanup";
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(results.keySet())) {
                    return;
                }
                final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, "Code Cleanup", true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(new SequentialCleanupTask(project2, results, progressTask));
                CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                    @Override
                    public void run() {
                        if (commandName != null) {
                            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                        }
                        ProgressManager.getInstance().run((Task)progressTask);
                        if (postRunnable != null) {
                            ApplicationManager.getApplication().invokeLater(postRunnable);
                        }
                    }
                }, "Code Cleanup", null);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    private static boolean isBinary(@NotNull PsiFile file2) {
        return file2 instanceof PsiBinaryFile || file2.getFileType().isBinary();
    }
}

