/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextBase
extends UserDataHolderBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final TObjectHashingStrategy<Tools> TOOLS_HASHING_STRATEGY = new TObjectHashingStrategy<Tools>(){

        public int computeHashCode(Tools object) {
            return object.getShortName().hashCode();
        }

        public boolean equals(Tools o1, Tools o2) {
            return o1.getShortName().equals(o2.getShortName());
        }
    };
    private RefManager myRefManager;
    private AnalysisScope myCurrentScope;
    @NotNull
    private final Project myProject;
    private final List<JobDescriptor> myJobDescriptors = new ArrayList<JobDescriptor>();
    private final StdJobDescriptors myStdJobDescriptors = new StdJobDescriptors();
    protected ProgressIndicator myProgressIndicator = new EmptyProgressIndicator();
    private InspectionProfile myExternalProfile;
    protected final Map<Key, GlobalInspectionContextExtension> myExtensions = new HashMap();
    protected final Map<String, Tools> myTools = new THashMap();
    @NonNls
    public static final String LOCAL_TOOL_ATTRIBUTE = "is_local_tool";

    public GlobalInspectionContextBase(@NotNull Project project2) {
        this.myProject = project2;
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    AnalysisScope getCurrentScope() {
        return this.myCurrentScope;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    public InspectionProfile getCurrentProfile() {
        if (this.myExternalProfile != null) {
            return this.myExternalProfile;
        }
        InspectionManagerBase managerEx = (InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject);
        String currentProfile = managerEx.getCurrentProfile();
        InspectionProjectProfileManager inspectionProfileManager = InspectionProjectProfileManager.getInstance(this.myProject);
        Profile profile = inspectionProfileManager.getProfile(currentProfile, false);
        if (profile == null) {
            profile = InspectionProfileManager.getInstance().getProfile(currentProfile);
            if (profile != null) {
                return (InspectionProfile)profile;
            }
            String[] availableProfileNames = inspectionProfileManager.getAvailableProfileNames();
            if (availableProfileNames.length == 0) {
                return null;
            }
            profile = inspectionProfileManager.getProfile(availableProfileNames[0]);
        }
        return (InspectionProfile)profile;
    }

    public boolean isSuppressed(@NotNull RefEntity entity, @NotNull String id) {
        return entity instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(id);
    }

    public boolean shouldCheck(@NotNull RefEntity entity, @NotNull GlobalInspectionTool tool) {
        return !(entity instanceof RefElementImpl) || this.isToCheckMember((RefElementImpl)entity, (InspectionProfileEntry)tool);
    }

    public boolean isSuppressed(@NotNull PsiElement element, @NotNull String id) {
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        if (refManager.isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id);
        }
        return SuppressionUtil.isSuppressed(element, id);
    }

    void cleanupTools() {
        this.myProgressIndicator.cancel();
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                toolWrapper.cleanup(this.myProject);
            }
        }
        this.myTools.clear();
        EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)this.getProject());
        if (entryPointsManager != null) {
            entryPointsManager.cleanup();
        }
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
        this.myJobDescriptors.clear();
    }

    public void setCurrentScope(@NotNull AnalysisScope currentScope) {
        this.myCurrentScope = currentScope;
    }

    public void doInspections(final @NotNull AnalysisScope scope) {
        if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, true)) {
            return;
        }
        this.cleanup();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalInspectionContextBase.this.myCurrentScope = scope;
                GlobalInspectionContextBase.this.launchInspections(scope);
            }
        }, ApplicationManager.getApplication().getDisposed());
    }

    @NotNull
    public RefManager getRefManager() {
        if (this.myRefManager == null) {
            this.myRefManager = (RefManager)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefManagerImpl>(){

                public RefManagerImpl compute() {
                    return new RefManagerImpl(GlobalInspectionContextBase.this.myProject, GlobalInspectionContextBase.this.myCurrentScope, GlobalInspectionContextBase.this);
                }
            });
        }
        return this.myRefManager;
    }

    public boolean isToCheckMember(@NotNull RefElement owner, @NotNull InspectionProfileEntry tool) {
        return this.isToCheckFile(((RefElementImpl)owner).getContainingFile(), tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName());
    }

    public boolean isToCheckFile(PsiFile file2, @NotNull InspectionProfileEntry tool) {
        Tools tools = this.myTools.get(tool.getShortName());
        if (tools != null && file2 != null) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope(file2.getProject());
                if (namedScope != null && !namedScope.getValue().contains(file2, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && state.getTool().getTool() == tool;
            }
        }
        return false;
    }

    protected void launchInspections(final @NotNull AnalysisScope scope) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"inspection.progress.title", (Object[])new Object[0]), true, this.createOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextBase.this.performInspectionsWithProgress(scope, false, false);
            }

            public void onSuccess() {
                GlobalInspectionContextBase.this.notifyInspectionsFinished(scope);
            }
        });
    }

    @NotNull
    protected PerformInBackgroundOption createOption() {
        return new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void processSentToBackground() {
            }
        };
    }

    protected void notifyInspectionsFinished(AnalysisScope scope) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInspectionsWithProgress(final @NotNull AnalysisScope scope, final boolean runGlobalToolsOnly, final boolean isOfflineInspections) {
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (this.myProgressIndicator == null) {
            throw new IllegalStateException("Inspections must be run under progress");
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            this.getStdJobDescriptors().BUILD_GRAPH.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
            this.getStdJobDescriptors().FIND_EXTERNAL_USAGES.setTotalAmount(0);
            ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    GlobalInspectionContextBase.this.runTools(scope, runGlobalToolsOnly, isOfflineInspections);
                }
            }, (ProgressIndicator)ProgressWrapper.wrap(this.myProgressIndicator));
        }
        catch (ProcessCanceledException e) {
            this.cleanup();
            throw e;
        }
        catch (IndexNotReadyException e) {
            this.cleanup();
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Usage search is not available until indices are ready");
            throw new ProcessCanceledException();
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
    }

    public void initializeTools(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<Tools> outGlobalSimpleTools) {
        List<Tools> usedTools = this.getUsedTools();
        for (Tools currentTools : usedTools) {
            JobDescriptor[] jobDescriptors;
            String shortName = currentTools.getShortName();
            this.myTools.put(shortName, currentTools);
            InspectionToolWrapper toolWrapper = currentTools.getTool();
            GlobalInspectionContextBase.classifyTool(outGlobalTools, outLocalTools, outGlobalSimpleTools, currentTools, toolWrapper);
            for (ScopeToolState state : currentTools.getTools()) {
                state.getTool().initialize((GlobalInspectionContext)this);
            }
            for (JobDescriptor jobDescriptor : jobDescriptors = toolWrapper.getJobDescriptors((GlobalInspectionContext)this)) {
                this.appendJobDescriptor(jobDescriptor);
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.performPreRunActivities(outGlobalTools, outLocalTools, (GlobalInspectionContext)this);
        }
    }

    @NotNull
    protected List<Tools> getUsedTools() {
        InspectionProfileImpl profile = new InspectionProfileImpl((InspectionProfileImpl)this.getCurrentProfile());
        List<Tools> tools = profile.getAllEnabledInspectionTools(this.myProject);
        LinkedHashSet<InspectionToolWrapper> dependentTools = new LinkedHashSet<InspectionToolWrapper>();
        for (Tools tool : tools) {
            profile.collectDependentInspections(tool.getTool(), dependentTools, this.getProject());
        }
        if (dependentTools.isEmpty()) {
            return tools;
        }
        THashSet set = new THashSet(tools, TOOLS_HASHING_STRATEGY);
        set.addAll(ContainerUtil.map(dependentTools, (Function)new Function<InspectionToolWrapper, ToolsImpl>(){

            public ToolsImpl fun(InspectionToolWrapper toolWrapper) {
                return new ToolsImpl(toolWrapper, toolWrapper.getDefaultLevel(), true, true);
            }
        }));
        return new ArrayList<Tools>((Collection<Tools>)set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void classifyTool(@NotNull List<Tools> outGlobalTools, @NotNull List<Tools> outLocalTools, @NotNull List<Tools> outGlobalSimpleTools, @NotNull Tools currentTools, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            outLocalTools.add(currentTools);
            return;
        } else {
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) throw new RuntimeException("unknown tool " + toolWrapper);
            if (toolWrapper.getTool() instanceof GlobalSimpleInspectionTool) {
                outGlobalSimpleTools.add(currentTools);
                return;
            } else {
                if (!(toolWrapper.getTool() instanceof GlobalInspectionTool)) throw new RuntimeException("unknown global tool " + toolWrapper);
                outGlobalTools.add(currentTools);
            }
        }
    }

    @NotNull
    public Map<String, Tools> getTools() {
        return this.myTools;
    }

    private void appendJobDescriptor(@NotNull JobDescriptor job) {
        if (!this.myJobDescriptors.contains(job)) {
            this.myJobDescriptors.add(job);
            job.setDoneAmount(0);
        }
    }

    public void codeCleanup(@NotNull Project project2, @NotNull AnalysisScope scope, @NotNull InspectionProfile profile, @Nullable String commandName, @Nullable Runnable postRunnable, boolean modal) {
    }

    public static void codeCleanup(@NotNull Project project2, @NotNull AnalysisScope scope, @Nullable Runnable runnable2) {
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project2).createNewGlobalContext(false);
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
        globalContext.codeCleanup(project2, scope, profile, null, runnable2, false);
    }

    public static void cleanupElements(final @NotNull Project project2, final @Nullable Runnable runnable2, PsiElement ... scope) {
        final ArrayList<SmartPsiElementPointer> elements = new ArrayList<SmartPsiElementPointer>();
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        for (PsiElement element : scope) {
            elements.add(manager.createSmartPsiElementPointer(element));
        }
        Runnable cleanupRunnable = new Runnable(){

            @Override
            public void run() {
                ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
                for (SmartPsiElementPointer element : elements) {
                    PsiElement psiElement = element.getElement();
                    if (psiElement == null || !psiElement.isPhysical()) continue;
                    psiElements.add(psiElement);
                }
                if (psiElements.isEmpty()) {
                    return;
                }
                GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)InspectionManager.getInstance((Project)project2).createNewGlobalContext(false);
                InspectionProfile profile = InspectionProjectProfileManager.getInstance(project2).getInspectionProfile();
                AnalysisScope analysisScope = new AnalysisScope((SearchScope)new LocalSearchScope(psiElements.toArray(new PsiElement[psiElements.size()])), project2);
                globalContext.codeCleanup(project2, analysisScope, profile, null, runnable2, true);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !application.isUnitTestMode()) {
            application.invokeLater(cleanupRunnable);
        } else {
            cleanupRunnable.run();
        }
    }

    public void close(boolean noSuspisiousCodeFound) {
        this.cleanup();
    }

    public void cleanup() {
        this.cleanupTools();
    }

    public void incrementJobDoneAmount(@NotNull JobDescriptor job, @NotNull String message) {
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job.getDoneAmount();
        job.setDoneAmount(old + 1);
        float totalProgress = this.getTotalProgress();
        this.myProgressIndicator.setFraction((double)totalProgress);
        this.myProgressIndicator.setText(job.getDisplayName() + " " + message);
    }

    private float getTotalProgress() {
        float totalDone = 0.0f;
        int totalTotal = 0;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalDone += (float)jobDescriptor.getDoneAmount();
            totalTotal += jobDescriptor.getTotalAmount();
        }
        return totalTotal == 0 ? 1.0f : totalDone / (float)totalTotal;
    }

    public void setExternalProfile(InspectionProfile profile) {
        this.myExternalProfile = profile;
    }

    @NotNull
    public StdJobDescriptors getStdJobDescriptors() {
        return this.myStdJobDescriptors;
    }
}

