/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EntryPointsManager")
public abstract class EntryPointsManagerBase
extends EntryPointsManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String[] STANDARD_ANNOS = new String[]{"javax.ws.rs.*"};
    private volatile List<String> ADDITIONAL_ANNOS;
    public JDOMExternalizableStringList ADDITIONAL_ANNOTATIONS = new JDOMExternalizableStringList();
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints;
    private final Set<RefElement> myTemporaryEntryPoints;
    private static final String VERSION = "2.0";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    private boolean myAddNonJavaEntries = true;
    private boolean myResolved = false;
    protected final Project myProject;
    private long myLastModificationCount = -1L;

    public Collection<String> getAdditionalAnnotations() {
        List<String> annos = this.ADDITIONAL_ANNOS;
        if (annos == null) {
            EntryPoint[] extensions;
            annos = new ArrayList<String>();
            Collections.addAll(annos, STANDARD_ANNOS);
            for (EntryPoint extension : extensions = (EntryPoint[])Extensions.getExtensions((String)"com.intellij.deadCode", null)) {
                Object[] ignoredAnnotations = extension.getIgnoreAnnotations();
                if (ignoredAnnotations == null) continue;
                ContainerUtil.addAll(annos, (Object[])ignoredAnnotations);
            }
            this.ADDITIONAL_ANNOS = annos = Collections.unmodifiableList(annos);
        }
        return annos;
    }

    public EntryPointsManagerBase(final Project project2) {
        this.myProject = project2;
        this.myTemporaryEntryPoints = new HashSet<RefElement>();
        this.myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
        Disposer.register((Disposable)project2, (Disposable)this);
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        ((ExtensionPointImpl)point).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<EntryPoint>(){

            public void extensionAdded(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                this.extensionRemoved(extension, pluginDescriptor);
            }

            public void extensionRemoved(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (EntryPointsManagerBase.this.ADDITIONAL_ANNOS != null) {
                    EntryPointsManagerBase.this.ADDITIONAL_ANNOS = null;
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ApplicationManager.getApplication().isDisposed()) {
                                return;
                            }
                            InspectionProfileManager.getInstance().fireProfileChanged(null);
                        }
                    });
                }
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
            }
        }, false, (Disposable)this);
    }

    public static EntryPointsManagerBase getInstance(Project project2) {
        return (EntryPointsManagerBase)((Object)ServiceManager.getService((Project)project2, EntryPointsManager.class));
    }

    public void loadState(Element element) {
        Element entryPointsElement = element.getChild("entry_points");
        if (entryPointsElement != null) {
            String version = entryPointsElement.getAttributeValue(VERSION_ATTR);
            if (!Comparing.strEqual((String)version, (String)VERSION)) {
                EntryPointsManagerBase.convert(entryPointsElement, this.myPersistentEntryPoints);
            } else {
                List content = entryPointsElement.getChildren();
                for (Object aContent : content) {
                    Element entryElement = (Element)aContent;
                    if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
                    SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(entryElement);
                    this.myPersistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
                }
            }
        }
        try {
            this.ADDITIONAL_ANNOTATIONS.readExternal(element);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Element getState() {
        Element element = new Element("state");
        EntryPointsManagerBase.writeExternal(element, this.myPersistentEntryPoints, this.ADDITIONAL_ANNOTATIONS);
        return element;
    }

    public static void writeExternal(Element element, Map<String, SmartRefElementPointer> persistentEntryPoints, JDOMExternalizableStringList additional_annotations) {
        Element entryPointsElement = new Element("entry_points");
        entryPointsElement.setAttribute(VERSION_ATTR, VERSION);
        for (SmartRefElementPointer entryPoint : persistentEntryPoints.values()) {
            assert (entryPoint.isPersistent());
            entryPoint.writeExternal(entryPointsElement);
        }
        element.addContent(entryPointsElement);
        if (!additional_annotations.isEmpty()) {
            additional_annotations.writeExternal(element);
        }
    }

    public void resolveEntryPoints(final @NotNull RefManager manager) {
        if (!this.myResolved) {
            this.myResolved = true;
            this.cleanup();
            this.validateEntryPoints();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (SmartRefElementPointer entryPoint : EntryPointsManagerBase.this.myPersistentEntryPoints.values()) {
                        if (!entryPoint.resolve(manager)) continue;
                        RefEntity refElement = entryPoint.getRefElement();
                        ((RefElementImpl)refElement).setEntry(true);
                        ((RefElementImpl)refElement).setPermanentEntry(entryPoint.isPersistent());
                    }
                }
            });
        }
    }

    private void purgeTemporaryEntryPoints() {
        for (RefElement entryPoint : this.myTemporaryEntryPoints) {
            ((RefElementImpl)entryPoint).setEntry(false);
        }
        this.myTemporaryEntryPoints.clear();
    }

    public void addEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        if (!newEntryPoint.isValid()) {
            return;
        }
        if (newEntryPoint instanceof RefClass) {
            RefClass refClass = (RefClass)newEntryPoint;
            if (refClass.isAnonymous()) {
                return;
            }
            List refConstructors = refClass.getConstructors();
            if (refConstructors.size() == 1) {
                this.addEntryPoint((RefElement)refConstructors.get(0), isPersistent);
            } else if (refConstructors.size() > 1) {
                for (int i = 0; i < refConstructors.size(); ++i) {
                    this.addEntryPoint((RefElement)refConstructors.get(i), isPersistent);
                }
            }
        }
        if (!isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else if (this.myPersistentEntryPoints.get(newEntryPoint.getExternalName()) == null) {
            EntryPointsManagerBase entryPointsManager;
            SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl((RefEntity)newEntryPoint, true);
            this.myPersistentEntryPoints.put(entry.getFQName(), entry);
            ((RefElementImpl)newEntryPoint).setEntry(true);
            ((RefElementImpl)newEntryPoint).setPermanentEntry(true);
            if (entry.isPersistent() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getElement().getProject()))) {
                entryPointsManager.addEntryPoint(newEntryPoint, true);
            }
        }
    }

    public void removeEntryPoint(@NotNull RefElement anEntryPoint) {
        Project project2;
        EntryPointsManagerBase entryPointsManager;
        RefClass refClass;
        if (anEntryPoint instanceof RefClass && !(refClass = (RefClass)anEntryPoint).isInterface()) {
            anEntryPoint = refClass.getDefaultConstructor();
        }
        if (anEntryPoint == null) {
            return;
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        Set<Map.Entry<String, SmartRefElementPointer>> set = this.myPersistentEntryPoints.entrySet();
        String key = null;
        for (Map.Entry<String, SmartRefElementPointer> entry : set) {
            SmartRefElementPointer value = entry.getValue();
            if (value.getRefElement() != anEntryPoint) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.myPersistentEntryPoints.remove(key);
            ((RefElementImpl)anEntryPoint).setEntry(false);
        }
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(project2 = anEntryPoint.getElement().getProject()))) {
            entryPointsManager.removeEntryPoint(anEntryPoint);
        }
    }

    @NotNull
    public RefElement[] getEntryPoints() {
        this.validateEntryPoints();
        ArrayList<RefElement> entries = new ArrayList<RefElement>();
        Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer refElementPointer : collection) {
            RefEntity elt = refElementPointer.getRefElement();
            if (!(elt instanceof RefElement)) continue;
            entries.add((RefElement)elt);
        }
        entries.addAll(this.myTemporaryEntryPoints);
        return entries.toArray(new RefElement[entries.size()]);
    }

    public void dispose() {
        this.cleanup();
    }

    private void validateEntryPoints() {
        long count = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (count != this.myLastModificationCount) {
            SmartRefElementPointer[] entries;
            this.myLastModificationCount = count;
            Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
            for (SmartRefElementPointer entry : entries = collection.toArray(new SmartRefElementPointer[collection.size()])) {
                RefElement refElement = (RefElement)entry.getRefElement();
                if (refElement == null || refElement.isValid()) continue;
                this.myPersistentEntryPoints.remove(entry.getFQName());
            }
            Iterator<RefElement> it = this.myTemporaryEntryPoints.iterator();
            while (it.hasNext()) {
                RefElement refElement = it.next();
                if (refElement.isValid()) continue;
                it.remove();
            }
        }
    }

    public void cleanup() {
        this.purgeTemporaryEntryPoints();
        Collection<SmartRefElementPointer> entries = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer entry : entries) {
            entry.freeReference();
        }
    }

    public boolean isAddNonJavaEntries() {
        return this.myAddNonJavaEntries;
    }

    public void addAllPersistentEntries(EntryPointsManagerBase manager) {
        this.myPersistentEntryPoints.putAll(manager.myPersistentEntryPoints);
    }

    public static void convert(Element element, Map<String, SmartRefElementPointer> persistentEntryPoints) {
        List content = element.getChildren();
        for (Object aContent : content) {
            Element entryElement = (Element)aContent;
            if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
            String fqName = entryElement.getAttributeValue("FQNAME");
            String type = entryElement.getAttributeValue("TYPE");
            if (Comparing.strEqual((String)type, (String)"method")) {
                int spaceIdx = fqName.indexOf(32);
                int lastDotIdx = fqName.lastIndexOf(46);
                int parenIndex = fqName.indexOf(40);
                while (lastDotIdx > parenIndex) {
                    lastDotIdx = fqName.lastIndexOf(46, lastDotIdx - 1);
                }
                boolean notype = false;
                if (spaceIdx < 0 || spaceIdx + 1 > lastDotIdx || spaceIdx > parenIndex) {
                    notype = true;
                }
                String className = fqName.substring(notype ? 0 : spaceIdx + 1, lastDotIdx);
                String methodSignature = notype ? fqName.substring(lastDotIdx + 1) : fqName.substring(0, spaceIdx) + ' ' + fqName.substring(lastDotIdx + 1);
                fqName = className + " " + methodSignature;
            } else if (Comparing.strEqual((String)type, (String)"field")) {
                int lastDotIdx = fqName.lastIndexOf(46);
                if (lastDotIdx <= 0 || lastDotIdx >= fqName.length() - 2) continue;
                String className = fqName.substring(0, lastDotIdx);
                String fieldName = fqName.substring(lastDotIdx + 1);
                fqName = className + " " + fieldName;
            }
            SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(type, fqName);
            persistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
        }
    }

    public void setAddNonJavaEntries(boolean addNonJavaEntries) {
        this.myAddNonJavaEntries = addNonJavaEntries;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)element;
        if (!this.ADDITIONAL_ANNOTATIONS.isEmpty() && this.ADDITIONAL_ANNOTATIONS.contains((Object)Deprecated.class.getName()) && element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return true;
        }
        return AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, (Collection)this.ADDITIONAL_ANNOTATIONS) || AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, this.getAdditionalAnnotations());
    }
}

