/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditInspectionToolsSettingsInSuppressedPlaceIntention
implements IntentionAction {
    private String myId;
    private String myDisplayName;

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"edit.inspection.options", (Object[])new Object[]{this.myDisplayName});
    }

    @Nullable
    private static String getSuppressedId(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement element = file2.findElementAt(offset); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
                String suppressedIds = factory.getSuppressedInspectionIdsIn(element);
                if (suppressedIds == null) continue;
                String text = element.getText();
                List ids = StringUtil.split((String)suppressedIds, (String)",");
                for (String id : ids) {
                    int idOffset;
                    int i = text.indexOf(id);
                    if (i == -1 || !TextRange.from((int)(idOffset = element.getTextRange().getStartOffset() + i), (int)id.length()).contains(offset)) continue;
                    return id;
                }
            }
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        this.myId = EditInspectionToolsSettingsInSuppressedPlaceIntention.getSuppressedId(editor, file2);
        if (this.myId != null) {
            InspectionToolWrapper toolWrapper = this.getTool(project2, file2);
            if (toolWrapper == null) {
                return false;
            }
            this.myDisplayName = toolWrapper.getDisplayName();
        }
        return this.myId != null;
    }

    @Nullable
    private InspectionToolWrapper getTool(Project project2, PsiFile file2) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)projectProfileManager.getInspectionProfile();
        return inspectionProfile.getToolById(this.myId, (PsiElement)file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        InspectionToolWrapper toolWrapper = this.getTool(project2, file2);
        if (toolWrapper == null) {
            return;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)projectProfileManager.getInspectionProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, false, toolWrapper.getShortName());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

