/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class EditInspectionToolsSettingsAction
implements IntentionAction,
Iconable,
HighPriorityAction {
    private final String myShortName;

    public EditInspectionToolsSettingsAction(@NotNull LocalInspectionTool tool) {
        this.myShortName = tool.getShortName();
    }

    public EditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key) {
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"edit.options.of.reporter.inspection.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(file2.getProject());
        InspectionProfile inspectionProfile = projectProfileManager.getInspectionProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, true, this.myShortName);
    }

    public boolean editToolSettings(Project project2, InspectionProfileImpl inspectionProfile, boolean canChooseDifferentProfiles) {
        return EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, canChooseDifferentProfiles, this.myShortName);
    }

    public static boolean editToolSettings(Project project2, final InspectionProfile inspectionProfile, boolean canChooseDifferentProfile, final String selectedToolShortName) {
        ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
        final ErrorsConfigurable errorsConfigurable = !canChooseDifferentProfile ? new ProjectInspectionToolsConfigurable(InspectionProfileManager.getInstance(), InspectionProjectProfileManager.getInstance(project2)) : ErrorsConfigurable.SERVICE.createConfigurable(project2);
        return settingsUtil.editConfigurable(project2, (Configurable)errorsConfigurable, new Runnable(){

            @Override
            public void run() {
                errorsConfigurable.selectProfile((Profile)inspectionProfile);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        errorsConfigurable.selectInspectionTool(selectedToolShortName);
                    }
                });
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.Settings;
    }
}

