/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableInspectionToolAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String myToolId;
    public static final String NAME = InspectionsBundle.message((String)"disable.inspection.action.name", (Object[])new Object[0]);

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key) {
        this.myToolId = key.toString();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfile inspectionProfile = profileManager.getInspectionProfile();
        InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool(this.myToolId, project2);
        return toolWrapper == null || toolWrapper.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    public void applyFix(@NotNull Project project2, final PsiFile file2, @Nullable Editor editor) {
        DisableInspectionToolAction.modifyAndCommitProjectProfile(new Consumer<ModifiableModel>(){

            public void consume(ModifiableModel modifiableModel) {
                modifiableModel.disableTool(DisableInspectionToolAction.this.myToolId, (PsiElement)file2);
            }
        }, project2);
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }

    public static void modifyAndCommitProjectProfile(Consumer<ModifiableModel> action, Project project2) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfile inspectionProfile = profileManager.getInspectionProfile();
        ModifiableModel model = inspectionProfile.getModifiableModel();
        action.consume((Object)model);
        try {
            model.commit();
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

