/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsAndHashcodeBase
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        final Project project2 = holder.getProject();
        Pair pair = (Pair)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, (CachedValueProvider)new CachedValueProvider<Pair<PsiMethod, PsiMethod>>(){

            public CachedValueProvider.Result<Pair<PsiMethod, PsiMethod>> compute() {
                final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
                PsiClass psiObjectClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                    @Nullable
                    public PsiClass compute() {
                        return psiFacade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project2));
                    }
                });
                if (psiObjectClass == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project2)});
                }
                PsiMethod[] methods = psiObjectClass.getMethods();
                PsiMethod myEquals = null;
                PsiMethod myHashCode = null;
                for (PsiMethod method : methods) {
                    String name = method.getName();
                    if ("equals".equals(name)) {
                        myEquals = method;
                        continue;
                    }
                    if (!"hashCode".equals(name)) continue;
                    myHashCode = method;
                }
                return CachedValueProvider.Result.create((Object)Pair.create(myEquals, myHashCode), (Object[])new Object[]{psiObjectClass});
            }
        });
        if (pair == null) {
            return new PsiElementVisitor(){};
        }
        final PsiMethod myEquals = (PsiMethod)pair.first;
        final PsiMethod myHashCode = (PsiMethod)pair.second;
        if (myEquals == null || myHashCode == null || !myEquals.isValid() || !myHashCode.isValid()) {
            return new PsiElementVisitor(){};
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                boolean[] hasEquals = new boolean[]{false};
                boolean[] hasHashCode = new boolean[]{false};
                EqualsAndHashcodeBase.processClass(aClass, hasEquals, hasHashCode, myEquals, myHashCode);
                if (hasEquals[0] != hasHashCode[0]) {
                    PsiIdentifier identifier = aClass.getNameIdentifier();
                    holder.registerProblem((PsiElement)(identifier != null ? identifier : aClass), hasEquals[0] ? InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>equals()</code>", "<code>hashCode()</code>"}) : InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>hashCode()</code>", "<code>equals()</code>"}), EqualsAndHashcodeBase.this.buildFixes(isOnTheFly, hasEquals[0]));
                }
            }
        };
    }

    private static void processClass(PsiClass aClass, boolean[] hasEquals, boolean[] hasHashCode, PsiMethod equals, PsiMethod hashcode) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)equals)) {
                hasEquals[0] = true;
                continue;
            }
            if (!MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)hashcode)) continue;
            hasHashCode[0] = true;
        }
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.equals.hashcode.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return "EqualsAndHashcode";
    }

    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        return LocalQuickFix.EMPTY_ARRAY;
    }
}

