/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    private final Map<String, Set<RefEntity>> myPackageContents = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<RefEntity>> myOldPackageContents = null;
    private final Set<RefEntity> myIgnoreElements = new HashSet();
    private WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    @NonNls
    private static final String[] HINTS = new String[]{"comment", "delete"};
    final QuickFixAction[] myQuickFixActions;
    private static final String DELETE_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    private static final String COMMENT_OUT_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);

    public UnusedDeclarationPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
        this.myQuickFixActions = this.createQuickFixes(toolWrapper);
        ((EntryPointsManagerBase)this.getEntryPointsManager()).setAddNonJavaEntries(this.getTool().ADD_NONJAVA_TO_ENTRIES);
    }

    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new WeakUnreferencedFilter(this.getTool(), this.getContext());
        }
        return this.myFilter;
    }

    @NotNull
    private UnusedDeclarationInspectionBase getTool() {
        return (UnusedDeclarationInspectionBase)this.getToolWrapper().getTool();
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer(this);
        }
        return this.myComposer;
    }

    @Override
    public void exportResults(@NotNull Element parentNode, @NotNull RefEntity refEntity) {
        if (!(refEntity instanceof RefJavaElement)) {
            return;
        }
        RefFilter filter = this.getFilter();
        if (!this.getIgnoredRefElements().contains(refEntity) && filter.accepts((RefJavaElement)refEntity)) {
            refEntity = this.getRefManager().getRefinedElement(refEntity);
            Element element = refEntity.getRefManager().export(refEntity, parentNode, -1);
            if (element == null) {
                return;
            }
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            RefElement refElement = (RefElement)refEntity;
            HighlightSeverity severity = this.getSeverity(refElement);
            String attributeKey = UnusedDeclarationPresentation.getTextAttributeKey(refElement.getRefManager().getProject(), severity, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", attributeKey);
            problemClassElement.addContent(InspectionsBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
            element.addContent(problemClassElement);
            Element hintsElement = new Element("hints");
            for (String hint : HINTS) {
                Element hintElement = new Element("hint");
                hintElement.setAttribute("value", hint);
                hintsElement.addContent(hintElement);
            }
            element.addContent(hintsElement);
            Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
            StringBuffer buf = new StringBuffer();
            DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
            descriptionElement.addContent(buf.toString());
            element.addContent(descriptionElement);
        }
    }

    @Override
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements) {
        return this.myQuickFixActions;
    }

    @NotNull
    private QuickFixAction[] createQuickFixes(@NotNull InspectionToolWrapper toolWrapper) {
        return new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBin(toolWrapper), new MoveToEntries(toolWrapper)};
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            String date = DateFormatUtil.formatDateTime((Date)new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    @Override
    @NotNull
    public InspectionNode createToolNode(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure) {
        EntryPointsNode entryPointsNode = new EntryPointsNode(context);
        InspectionToolWrapper dummyToolWrapper = entryPointsNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(dummyToolWrapper);
        presentation.updateContent();
        provider.appendToolNodeContent(context, entryPointsNode, node, showStructure);
        return entryPointsNode;
    }

    @Override
    public void updateContent() {
        this.getTool().checkForReachables(this.getContext());
        this.myPackageContents.clear();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if ((!UnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !UnusedDeclarationPresentation.this.getIgnoredRefElements().contains(refElement)) && refElement.isValid() && UnusedDeclarationPresentation.this.getFilter().accepts(refElement)) {
                    String packageName = RefJavaUtil.getInstance().getPackageName(refEntity);
                    Set content = (Set)UnusedDeclarationPresentation.this.myPackageContents.get(packageName);
                    if (content == null) {
                        content = new HashSet();
                        UnusedDeclarationPresentation.this.myPackageContents.put(packageName, content);
                    }
                    content.add(refEntity);
                }
            }
        });
    }

    @Override
    public boolean hasReportedProblems() {
        GlobalInspectionContextImpl context = this.getContext();
        if (!this.isDisposed() && context.getUIOptions().SHOW_ONLY_DIFF) {
            return this.containsOnlyDiff(this.myPackageContents) || this.myOldPackageContents != null && this.containsOnlyDiff(this.myOldPackageContents);
        }
        if (!this.myPackageContents.isEmpty()) {
            return true;
        }
        return this.isOldProblemsIncluded() && !this.myOldPackageContents.isEmpty();
    }

    private boolean containsOnlyDiff(@NotNull Map<String, Set<RefEntity>> packageContents) {
        for (String packageName : packageContents.keySet()) {
            Set<RefEntity> refElements = packageContents.get(packageName);
            if (refElements == null) continue;
            for (RefEntity refElement : refElements) {
                if (this.getElementStatus(refElement) == FileStatus.NOT_CHANGED) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        return this.myPackageContents;
    }

    @Override
    public Map<String, Set<RefEntity>> getOldContent() {
        return this.myOldPackageContents;
    }

    @Override
    public void ignoreCurrentElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.myIgnoreElements.add(refEntity);
    }

    @Override
    public void amnesty(RefEntity refEntity) {
        this.myIgnoreElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.myOldPackageContents = null;
        this.myPackageContents.clear();
        this.myIgnoreElements.clear();
    }

    @Override
    public void finalCleanup() {
        super.finalCleanup();
        this.myOldPackageContents = null;
    }

    @Override
    public boolean isGraphNeeded() {
        return true;
    }

    @Override
    public boolean isElementIgnored(RefEntity element) {
        for (RefEntity entity : this.myIgnoreElements) {
            if (!Comparing.equal((Object)entity, (Object)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public FileStatus getElementStatus(RefEntity element) {
        GlobalInspectionContextImpl context = this.getContext();
        if (!this.isDisposed() && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN) {
            if (this.myOldPackageContents != null) {
                boolean old = RefUtil.contains((RefEntity)element, UnusedDeclarationPresentation.collectRefElements(this.myOldPackageContents));
                boolean current = RefUtil.contains((RefEntity)element, UnusedDeclarationPresentation.collectRefElements(this.myPackageContents));
                return UnusedDeclarationPresentation.calcStatus(old, current);
            }
            return FileStatus.ADDED;
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    @NotNull
    public Collection<RefEntity> getIgnoredRefElements() {
        return this.myIgnoreElements;
    }

    private static Set<RefEntity> collectRefElements(Map<String, Set<RefEntity>> packageContents) {
        HashSet allAvailable = new HashSet();
        for (Set<RefEntity> elements : packageContents.values()) {
            allAvailable.addAll(elements);
        }
        return allAvailable;
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(@NotNull CommonProblemDescriptor descriptor, String hint) {
        if (descriptor instanceof ProblemDescriptor) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
        }
        return null;
    }

    private static class PermanentDeleteFix
    implements IntentionAction {
        private final PsiElement myElement;

        private PermanentDeleteFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            return DELETE_QUICK_FIX;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (this.myElement != null && this.myElement.isValid()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SafeDeleteHandler.invoke(myElement.getProject(), new PsiElement[]{PsiTreeUtil.getParentOfType((PsiElement)myElement, PsiModifierListOwner.class)}, false);
                    }
                });
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class CommentOutFix
    implements IntentionAction {
        private final PsiElement myElement;

        private CommentOutFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            return COMMENT_OUT_QUICK_FIX;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (this.myElement != null && this.myElement.isValid()) {
                UnusedDeclarationPresentation.commentOutDead(PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class));
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    class CommentOutBin
    extends QuickFixAction {
        CommentOutBin(InspectionToolWrapper toolWrapper) {
            super(COMMENT_OUT_QUICK_FIX, null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), toolWrapper);
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
                if (psiElement == null || UnusedDeclarationPresentation.this.getFilter().getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                UnusedDeclarationPresentation.commentOutDead(psiElement);
                refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            return true;
        }
    }

    class MoveToEntries
    extends QuickFixAction {
        MoveToEntries(InspectionToolWrapper toolWrapper) {
            super(InspectionsBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, KeyStroke.getKeyStroke(155, 0), toolWrapper);
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.addEntryPoint((RefElement)refElement, true);
            }
            return true;
        }
    }

    class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper toolWrapper) {
            super(DELETE_QUICK_FIX, AllIcons.Actions.Cancel, KeyStroke.getKeyStroke(127, 0), toolWrapper);
        }

        @Override
        protected boolean applyFix(final @NotNull RefEntity[] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            final ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
                if (psiElement == null || UnusedDeclarationPresentation.this.getFilter().getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                psiElements.add(psiElement);
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    final Project project2 = UnusedDeclarationPresentation.this.getContext().getProject();
                    if (UnusedDeclarationPresentation.this.isDisposed() || project2.isDisposed()) {
                        return;
                    }
                    SafeDeleteHandler.invoke(project2, PsiUtilCore.toPsiElementArray((Collection)psiElements), false, new Runnable(){

                        @Override
                        public void run() {
                            QuickFixAction.removeElements(refElements, project2, PermanentDeleteAction.this.myToolWrapper);
                        }
                    });
                }
            });
            return false;
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContextImpl context) {
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            return 0;
        }
    }
}

