/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.RefEntryPointFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.util.RefFilter;
import org.jetbrains.annotations.NotNull;

public class DummyEntryPointsPresentation
extends UnusedDeclarationPresentation {
    private static final RefEntryPointFilter myFilter = new RefEntryPointFilter();
    private QuickFixAction[] myQuickFixActions;

    public DummyEntryPointsPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
    }

    @Override
    public RefFilter getFilter() {
        return myFilter;
    }

    @Override
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements) {
        if (this.myQuickFixActions == null) {
            this.myQuickFixActions = new QuickFixAction[]{new MoveEntriesToSuspicious(this.getToolWrapper())};
        }
        return this.myQuickFixActions;
    }

    @Override
    protected String getSeverityDelegateName() {
        return "unused";
    }

    @Override
    @NotNull
    public InspectionNode createToolNode(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure) {
        return node;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        return new DeadHTMLComposer(this);
    }

    private class MoveEntriesToSuspicious
    extends QuickFixAction {
        private MoveEntriesToSuspicious(InspectionToolWrapper toolWrapper) {
            super(InspectionsBundle.message((String)"inspection.dead.code.remove.from.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            EntryPointsManager entryPointsManager = ((GlobalJavaInspectionContext)DummyEntryPointsPresentation.this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(DummyEntryPointsPresentation.this.getContext().getRefManager());
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.removeEntryPoint((RefElement)refElement);
            }
            return true;
        }
    }
}

