/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableValue
extends DfaValue {
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMember())});
    private final PsiModifierListOwner myVariable;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaVariableValue myNegatedValue;
    private final boolean myIsNegated;
    private Nullness myInherentNullability;
    private final DfaTypeValue myTypeValue;
    private final List<DfaVariableValue> myDependents = new SmartList();

    private DfaVariableValue(@NotNull PsiModifierListOwner variable, @Nullable PsiType varType, boolean isNegated, DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        super(factory);
        this.myVariable = variable;
        this.myIsNegated = isNegated;
        this.myQualifier = qualifier;
        this.myVarType = varType;
        DfaValue typeValue = this.myFactory.createTypeValue(varType, Nullness.UNKNOWN);
        DfaTypeValue dfaTypeValue = this.myTypeValue = typeValue instanceof DfaTypeValue ? (DfaTypeValue)typeValue : null;
        if (varType != null && !varType.isValid()) {
            PsiUtil.ensureValidType((PsiType)varType, (String)("Variable: " + variable + " of class " + variable.getClass()));
        }
    }

    @Nullable
    public DfaTypeValue getTypeValue() {
        return this.myTypeValue;
    }

    @NotNull
    public PsiModifierListOwner getPsiVariable() {
        return this.myVariable;
    }

    @Nullable
    public PsiType getVariableType() {
        return this.myVarType;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public DfaVariableValue getNegatedValue() {
        return this.myNegatedValue;
    }

    @Override
    public DfaVariableValue createNegated() {
        if (this.myNegatedValue != null) {
            return this.myNegatedValue;
        }
        this.myNegatedValue = this.myFactory.getVarFactory().createVariableValue(this.myVariable, this.myVarType, !this.myIsNegated, this.myQualifier);
        return this.myNegatedValue;
    }

    public String toString() {
        return (this.myIsNegated ? "!" : "") + ((PsiNamedElement)this.myVariable).getName() + (this.myQualifier == null ? "" : "|" + this.myQualifier.toString());
    }

    private boolean hardEquals(PsiModifierListOwner psiVar, PsiType varType, boolean negated, DfaVariableValue qualifier) {
        return psiVar == this.myVariable && Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)varType), (Object)TypeConversionUtil.erasure((PsiType)this.myVarType)) && negated == this.myIsNegated && (this.myQualifier == null ? qualifier == null : this.myQualifier.hardEquals(qualifier.getPsiVariable(), qualifier.getVariableType(), qualifier.isNegated(), qualifier.getQualifier()));
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    @NotNull
    public Nullness getInherentNullability() {
        if (this.myInherentNullability != null) {
            return this.myInherentNullability;
        }
        this.myInherentNullability = this.calcInherentNullability();
        return this.myInherentNullability;
    }

    @NotNull
    private Nullness calcInherentNullability() {
        PsiType itemType;
        PsiExpression iteratedValue;
        Nullness defaultNullability;
        PsiModifierListOwner var = this.getPsiVariable();
        Nullness nullability = DfaPsiUtil.getElementNullability(this.getVariableType(), var);
        if (nullability != Nullness.UNKNOWN) {
            return nullability;
        }
        Nullness nullness = defaultNullability = this.myFactory.isUnknownMembersAreNullable() && MEMBER_OR_METHOD_PARAMETER.accepts((Object)var) ? Nullness.NULLABLE : Nullness.UNKNOWN;
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType(iteratedValue)) != null) {
            return DfaPsiUtil.getElementNullability(itemType, var);
        }
        if (var instanceof PsiField && DfaPsiUtil.isFinalField((PsiVariable)var) && this.myFactory.isHonorFieldInitializers()) {
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers((PsiField)var);
            if (initializers.isEmpty()) {
                return defaultNullability;
            }
            boolean hasUnknowns = false;
            for (PsiExpression expression : initializers) {
                Nullness nullness2 = DfaVariableValue.getFieldInitializerNullness(expression);
                if (nullness2 == Nullness.NULLABLE) {
                    return Nullness.NULLABLE;
                }
                if (nullness2 != Nullness.UNKNOWN) continue;
                hasUnknowns = true;
            }
            if (hasUnknowns) {
                if (DfaPsiUtil.isInitializedNotNull((PsiField)var)) {
                    return Nullness.NOT_NULL;
                }
                return defaultNullability;
            }
            return Nullness.NOT_NULL;
        }
        return defaultNullability;
    }

    private static Nullness getFieldInitializerNullness(@NotNull PsiExpression expression) {
        if (expression.textMatches((CharSequence)"null")) {
            return Nullness.NULLABLE;
        }
        if (expression instanceof PsiNewExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiPolyadicExpression) {
            return Nullness.NOT_NULL;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            return DfaPsiUtil.getElementNullability(null, (PsiModifierListOwner)target);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullability(null, (PsiModifierListOwner)method) : Nullness.UNKNOWN;
        }
        return Nullness.UNKNOWN;
    }

    public boolean isFlushableByCalls() {
        if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter) {
            return false;
        }
        if (this.myVariable instanceof PsiVariable && this.myVariable.hasModifierProperty("final")) {
            return this.myQualifier != null && this.myQualifier.isFlushableByCalls();
        }
        return true;
    }

    public boolean containsCalls() {
        return this.myVariable instanceof PsiMethod || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public static class Factory {
        private final MultiMap<Trinity<Boolean, String, DfaVariableValue>, DfaVariableValue> myExistingVars = new MultiMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaVariableValue createVariableValue(PsiVariable myVariable, boolean isNegated) {
            PsiType varType = myVariable.getType();
            if (varType instanceof PsiEllipsisType) {
                varType = new PsiArrayType(((PsiEllipsisType)varType).getComponentType());
            }
            return this.createVariableValue((PsiModifierListOwner)myVariable, varType, isNegated, null);
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull PsiModifierListOwner myVariable, @Nullable PsiType varType, boolean isNegated, @Nullable DfaVariableValue qualifier) {
            Trinity key = Trinity.create((Object)isNegated, (Object)((PsiNamedElement)myVariable).getName(), (Object)qualifier);
            for (DfaVariableValue aVar : this.myExistingVars.get((Object)key)) {
                if (!aVar.hardEquals(myVariable, varType, isNegated, qualifier)) continue;
                return aVar;
            }
            DfaVariableValue result = new DfaVariableValue(myVariable, varType, isNegated, this.myFactory, qualifier);
            this.myExistingVars.putValue((Object)key, (Object)result);
            while (qualifier != null) {
                qualifier.myDependents.add(result);
                qualifier = qualifier.getQualifier();
            }
            return result;
        }

        @NotNull
        public List<DfaVariableValue> getAllQualifiedBy(@NotNull DfaVariableValue value) {
            return value.myDependents;
        }
    }
}

