/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DfaPsiType {
    private final PsiType myPsiType;
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache;
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache;

    DfaPsiType(@NotNull PsiType psiType, Map<Pair<DfaPsiType, DfaPsiType>, Boolean> assignableCache, Map<Pair<DfaPsiType, DfaPsiType>, Boolean> convertibleCache) {
        this.myPsiType = psiType;
        this.myAssignableCache = assignableCache;
        this.myConvertibleCache = convertibleCache;
    }

    @NotNull
    public PsiType getPsiType() {
        return this.myPsiType;
    }

    public boolean isAssignableFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key = Pair.create((Object)this, (Object)other);
        Boolean result = this.myAssignableCache.get(key);
        if (result == null) {
            result = this.myPsiType.isAssignableFrom(other.myPsiType);
            this.myAssignableCache.put((Pair<DfaPsiType, DfaPsiType>)key, result);
        }
        return result;
    }

    public boolean isConvertibleFrom(DfaPsiType other) {
        if (other == this) {
            return true;
        }
        Pair key = Pair.create((Object)this, (Object)other);
        Boolean result = this.myConvertibleCache.get(key);
        if (result == null) {
            result = this.myPsiType.isConvertibleFrom(other.myPsiType);
            this.myConvertibleCache.put((Pair<DfaPsiType, DfaPsiType>)key, result);
        }
        return result;
    }

    public String toString() {
        return this.myPsiType.getPresentableText();
    }
}

