/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    private final DfaValue myWrappedValue;

    private DfaBoxedValue(DfaValue valueToWrap, DfaValueFactory factory) {
        super(factory);
        this.myWrappedValue = valueToWrap;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    public DfaValue getWrappedValue() {
        return this.myWrappedValue;
    }

    public static class Factory {
        private final Map<Object, DfaBoxedValue> cachedValues = new HashMap();
        private final DfaValueFactory myFactory;
        private final Map<DfaVariableValue, DfaUnboxedValue> cachedUnboxedValues = ContainerUtil.newTroveMap();

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap) {
            Object o;
            if (valueToWrap instanceof DfaUnboxedValue) {
                return ((DfaUnboxedValue)valueToWrap).getVariable();
            }
            Object object = valueToWrap instanceof DfaConstValue ? ((DfaConstValue)valueToWrap).getValue() : (o = valueToWrap instanceof DfaVariableValue ? valueToWrap : null);
            if (o == null) {
                return null;
            }
            DfaBoxedValue boxedValue = this.cachedValues.get(o);
            if (boxedValue == null) {
                boxedValue = new DfaBoxedValue(valueToWrap, this.myFactory);
                this.cachedValues.put(o, boxedValue);
            }
            return boxedValue;
        }

        @NotNull
        public DfaValue createUnboxed(DfaValue value) {
            if (value instanceof DfaBoxedValue) {
                return ((DfaBoxedValue)value).getWrappedValue();
            }
            if (value instanceof DfaConstValue) {
                if (value == value.myFactory.getConstFactory().getNull()) {
                    return DfaUnknownValue.getInstance();
                }
                return value;
            }
            if (value instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)value;
                DfaUnboxedValue result = this.cachedUnboxedValues.get(var);
                if (result == null) {
                    result = new DfaUnboxedValue(var, this.myFactory);
                    this.cachedUnboxedValues.put(var, result);
                }
                return result;
            }
            return DfaUnknownValue.getInstance();
        }
    }
}

