/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiExpression;
import com.intellij.util.containers.FList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValuableDataFlowRunner
extends DataFlowRunner {
    ValuableDataFlowRunner() {
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new MyDfaMemoryState(this.getFactory());
    }

    static class ValuableDfaVariableState
    extends DfaVariableState {
        private final DfaValue myValue;
        @NotNull
        final FList<PsiExpression> myConcatenation;

        private ValuableDfaVariableState(@NotNull DfaVariableValue psiVariable) {
            super(psiVariable);
            this.myValue = null;
            this.myConcatenation = FList.emptyList();
        }

        private ValuableDfaVariableState(Set<DfaPsiType> instanceofValues, Set<DfaPsiType> notInstanceofValues, Nullness nullability, DfaValue value, @NotNull FList<PsiExpression> concatenation) {
            super(instanceofValues, notInstanceofValues, nullability);
            this.myValue = value;
            this.myConcatenation = concatenation;
        }

        @Override
        @NotNull
        protected DfaVariableState createCopy(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull Nullness nullability) {
            return new ValuableDfaVariableState(instanceofValues, notInstanceofValues, nullability, this.myValue, this.myConcatenation);
        }

        @Override
        @NotNull
        public DfaVariableState withValue(@Nullable DfaValue value) {
            if (value == this.myValue) {
                return this;
            }
            return new ValuableDfaVariableState(this.myInstanceofValues, this.myNotInstanceofValues, this.myNullability, value, this.myConcatenation);
        }

        ValuableDfaVariableState withExpression(@NotNull FList<PsiExpression> concatenation) {
            if (concatenation == this.myConcatenation) {
                return this;
            }
            return new ValuableDfaVariableState(this.myInstanceofValues, this.myNotInstanceofValues, this.myNullability, this.myValue, concatenation);
        }

        @Override
        public DfaValue getValue() {
            return this.myValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValuableDfaVariableState)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuableDfaVariableState state = (ValuableDfaVariableState)o;
            if (!this.myConcatenation.equals(state.myConcatenation)) {
                return false;
            }
            return !(this.myValue != null ? !this.myValue.equals(state.myValue) : state.myValue != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
            result = 31 * result + this.myConcatenation.hashCode();
            return result;
        }
    }

    static class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        private MyDfaMemoryState(@NotNull DfaValueFactory factory) {
            super(factory);
        }

        private MyDfaMemoryState(@NotNull DfaMemoryStateImpl toCopy) {
            super(toCopy);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            return new MyDfaMemoryState(this);
        }

        @Override
        @NotNull
        protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
            return new ValuableDfaVariableState(var);
        }

        @Override
        public void flushFields() {
        }
    }
}

