/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression) {
        return StringExpressionHelper.evaluateExpression(expression, (Collection<PsiElement>)new com.intellij.util.containers.hash.HashSet());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr;
        PsiExpression initializer;
        PsiElement resolve;
        visited.add(expression);
        if (expression instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression);
        }
        if (expression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) != null && (expr = StringExpressionHelper.evaluateExpression((PsiElement)initializer, visited)) != null) {
            return expr;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body = ((PsiMethod)element).getBody();
                if (body != null) {
                    HashSet returns = new HashSet();
                    body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)returns){
                        final /* synthetic */ Set val$returns;
                        {
                            this.val$returns = set;
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement2) {
                            PsiExpression returnValue = statement2.getReturnValue();
                            if (returnValue != null) {
                                this.val$returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)psiExpression, visited);
                        if (pair == null) continue;
                        return pair;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression, visited, ((PsiPolyadicExpression)expression).getOperands());
        }
        Collection<? extends PsiElement> elements = DfaUtil.getPossibleInitializationElements(expression);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr2;
            if (visited.contains(psiElement) || (expr2 = StringExpressionHelper.evaluateExpression(psiElement)) == null) continue;
            return expr2;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression, @NotNull Collection<PsiElement> visited, PsiExpression ... operands) {
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand : operands) {
            Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)operand, visited);
            if (pair == null) {
                return null;
            }
            sb.append((String)pair.second);
        }
        return Pair.create((Object)expression, (Object)sb.toString());
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression) {
        return Pair.create((Object)expression, (Object)ElementManipulators.getValueText((PsiElement)expression));
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression) {
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)expression.getProject()).getConstantEvaluationHelper();
        Object result = helper.computeConstantExpression(expression);
        if (result instanceof String) {
            return Pair.create((Object)expression, (Object)((String)result));
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        HashSet pairs = new HashSet();
        for (PsiMethodCallExpression methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression;
            Pair<PsiElement, String> pair;
            PsiExpression[] expressions = methodCallExpression.getArgumentList().getExpressions();
            if (expressions.length <= expNum || (pair = StringExpressionHelper.evaluateExpression((PsiElement)(expression = expressions[expNum]))) == null) continue;
            pairs.add(pair);
        }
        return pairs;
    }

    @NotNull
    public static Set<PsiMethodCallExpression> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        HashSet callExpressions = new HashSet();
        CommonProcessors.CollectUniquesProcessor consumer = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)consumer);
        for (PsiReference psiReference : consumer.getResults()) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        return callExpressions;
    }
}

