/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    final Set<DfaPsiType> myNotInstanceofValues;
    @NotNull
    final Nullness myNullability;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        this(Collections.emptySet(), Collections.emptySet(), dfaVar.getInherentNullability());
    }

    DfaVariableState(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull Nullness nullability) {
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
        this.myNullability = nullability;
        this.myHash = (this.myInstanceofValues.hashCode() * 31 + this.myNotInstanceofValues.hashCode()) * 31 + this.myNullability.hashCode();
    }

    public boolean isNullable() {
        return this.myNullability == Nullness.NULLABLE;
    }

    private boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (this.checkInstanceofValue(dfaType.getDfaType())) {
            DfaVariableState result = dfaType.isNullable() ? this.withNullability(Nullness.NULLABLE) : this;
            ArrayList moreGeneric = ContainerUtil.newArrayList();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (dfaType.getDfaType().isAssignableFrom(alreadyInstanceof)) {
                    return result;
                }
                if (!alreadyInstanceof.isAssignableFrom(dfaType.getDfaType())) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(dfaType.getDfaType());
            result = this.createCopy(newInstanceof, this.myNotInstanceofValues, result.myNullability);
            return result;
        }
        return null;
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (this.myNotInstanceofValues.contains(dfaType.getDfaType())) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!dfaType.getDfaType().isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList moreSpecific = ContainerUtil.newArrayList();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(dfaType.getDfaType())) {
                return this;
            }
            if (!dfaType.getDfaType().isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(dfaType.getDfaType());
        return this.createCopy(this.myInstanceofValues, hashSet, this.myNullability);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type) {
        if (this.myInstanceofValues.contains(type)) {
            HashSet newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            return this.createCopy(newInstanceof, this.myNotInstanceofValues, this.myNullability);
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            return this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myNullability);
        }
        return this;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && this.myNullability == aState.myNullability && this.myInstanceofValues.equals(aState.myInstanceofValues) && this.myNotInstanceofValues.equals(aState.myNotInstanceofValues);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull Nullness nullability) {
        return new DfaVariableState(instanceofValues, notInstanceofValues, nullability);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.myNullability);
        if (!this.myInstanceofValues.isEmpty()) {
            buf.append(" instanceof ").append(StringUtil.join(this.myInstanceofValues, (String)","));
        }
        if (!this.myNotInstanceofValues.isEmpty()) {
            buf.append(" not instanceof ").append(StringUtil.join(this.myNotInstanceofValues, (String)","));
        }
        return buf.toString();
    }

    @NotNull
    Nullness getNullability() {
        return this.myNullability;
    }

    public boolean isNotNull() {
        return this.myNullability == Nullness.NOT_NULL;
    }

    @NotNull
    DfaVariableState withNullability(@NotNull Nullness nullness) {
        return this.myNullability == nullness ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, nullness);
    }

    @NotNull
    DfaVariableState withNullable(boolean nullable) {
        return this.myNullability != Nullness.NOT_NULL ? this.withNullability(nullable ? Nullness.NULLABLE : Nullness.UNKNOWN) : this;
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value) {
        return this;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    public Set<DfaPsiType> getInstanceofValues() {
        return this.myInstanceofValues;
    }

    public Set<DfaPsiType> getNotInstanceofValues() {
        return this.myNotInstanceofValues;
    }
}

