/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class HKey {
    @NotNull
    final byte[] key;
    final int dirKey;
    final boolean stable;
    final boolean negated;

    HKey(@NotNull byte[] key, int dirKey, boolean stable, boolean negated) {
        this.key = key;
        this.dirKey = dirKey;
        this.stable = stable;
        this.negated = negated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HKey hKey = (HKey)o;
        if (this.dirKey != hKey.dirKey) {
            return false;
        }
        if (this.stable != hKey.stable) {
            return false;
        }
        if (this.negated != hKey.negated) {
            return false;
        }
        return Arrays.equals(this.key, hKey.key);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 31 * result + this.dirKey;
        result = 31 * result + (this.stable ? 1 : 0);
        result = 31 * result + (this.negated ? 1 : 0);
        return result;
    }

    HKey invertStability() {
        return new HKey(this.key, this.dirKey, !this.stable, this.negated);
    }

    HKey mkStable() {
        return this.stable ? this : new HKey(this.key, this.dirKey, true, this.negated);
    }

    HKey mkUnstable() {
        return this.stable ? new HKey(this.key, this.dirKey, false, this.negated) : this;
    }

    public HKey mkBase() {
        return this.dirKey == 0 ? this : new HKey(this.key, 0, this.stable, false);
    }

    HKey updateDirection(int newDirKey) {
        return new HKey(this.key, newDirKey, this.stable, false);
    }

    HKey negate() {
        return new HKey(this.key, this.dirKey, this.stable, true);
    }
}

