/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HUtils;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class HComponent {
    @NotNull
    Value value;
    @NotNull
    final HKey[] ids;

    HComponent(@NotNull Value value, @NotNull HKey[] ids) {
        this.value = value;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HComponent that = (HComponent)o;
        if (!Arrays.equals(this.ids, that.ids)) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + Arrays.hashCode(this.ids);
        return result;
    }

    public boolean remove(@NotNull HKey id) {
        return HUtils.remove(this.ids, id);
    }

    public boolean isEmpty() {
        return HUtils.isEmpty(this.ids);
    }

    @NotNull
    public HComponent copy() {
        return new HComponent(this.value, (HKey[])this.ids.clone());
    }
}

