/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffects;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnalysisConverter {
    public static final int CLASS_HASH_SIZE = 10;
    public static final int SIGNATURE_HASH_SIZE = 4;
    public static final int HASH_SIZE = 14;
    private static final ThreadLocalCachedValue<MessageDigest> HASHER_CACHE = new ThreadLocalCachedValue<MessageDigest>(){

        public MessageDigest create() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new RuntimeException(exception);
            }
        }

        protected void init(MessageDigest value) {
            value.reset();
        }
    };

    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return (MessageDigest)HASHER_CACHE.getValue();
    }

    @NotNull
    static DirectionResultPair convert(@NotNull Equation equation, @NotNull MessageDigest md) {
        HResult hResult;
        ProgressManager.checkCanceled();
        Result rhs = equation.rhs;
        if (rhs instanceof Final) {
            hResult = new HFinal(((Final)rhs).value);
        } else if (rhs instanceof Pending) {
            Pending pending = (Pending)rhs;
            Set<Product> sumOrigin = pending.sum;
            HComponent[] components = new HComponent[sumOrigin.size()];
            int componentI = 0;
            for (Product prod : sumOrigin) {
                HComponent intIdComponent;
                HKey[] intProd = new HKey[prod.ids.size()];
                int idI = 0;
                for (Key key : prod.ids) {
                    intProd[idI] = BytecodeAnalysisConverter.asmKey(key, md);
                    ++idI;
                }
                components[componentI] = intIdComponent = new HComponent(prod.value, intProd);
                ++componentI;
            }
            hResult = new HPending(components);
        } else {
            Effects wrapper = (Effects)rhs;
            Set<EffectQuantum> effects = wrapper.effects;
            HashSet<HEffectQuantum> hEffects = new HashSet<HEffectQuantum>();
            for (EffectQuantum effect : effects) {
                if (effect == EffectQuantum.TopEffectQuantum) {
                    hEffects.add(HEffectQuantum.TopEffectQuantum);
                    continue;
                }
                if (effect == EffectQuantum.ThisChangeQuantum) {
                    hEffects.add(HEffectQuantum.ThisChangeQuantum);
                    continue;
                }
                if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                    EffectQuantum.ParamChangeQuantum paramChangeQuantum = (EffectQuantum.ParamChangeQuantum)effect;
                    hEffects.add(new HEffectQuantum.ParamChangeQuantum(paramChangeQuantum.n));
                    continue;
                }
                if (!(effect instanceof EffectQuantum.CallQuantum)) continue;
                EffectQuantum.CallQuantum callQuantum = (EffectQuantum.CallQuantum)effect;
                hEffects.add(new HEffectQuantum.CallQuantum(BytecodeAnalysisConverter.asmKey(callQuantum.key, md), callQuantum.data, callQuantum.isStatic));
            }
            hResult = new HEffects(hEffects);
        }
        return new DirectionResultPair(BytecodeAnalysisConverter.mkDirectionKey(equation.id.direction), hResult);
    }

    @NotNull
    public static HKey asmKey(@NotNull Key key, @NotNull MessageDigest md) {
        byte[] classDigest = md.digest(key.method.internalClassName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(key.method.methodName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(key.method.methodDesc.getBytes(CharsetToolkit.UTF8_CHARSET));
        byte[] sigDigest = md.digest();
        byte[] digest = new byte[14];
        System.arraycopy(classDigest, 0, digest, 0, 10);
        System.arraycopy(sigDigest, 0, digest, 10, 4);
        return new HKey(digest, BytecodeAnalysisConverter.mkDirectionKey(key.direction), key.stable, key.negated);
    }

    @Nullable
    public static HKey psiKey(@NotNull PsiMethod psiMethod, @NotNull Direction direction, @NotNull MessageDigest md) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return null;
        }
        byte[] classDigest = BytecodeAnalysisConverter.psiClassDigest(psiClass, md);
        if (classDigest == null) {
            return null;
        }
        byte[] sigDigest = BytecodeAnalysisConverter.methodDigest(psiMethod, md);
        if (sigDigest == null) {
            return null;
        }
        byte[] digest = new byte[14];
        System.arraycopy(classDigest, 0, digest, 0, 10);
        System.arraycopy(sigDigest, 0, digest, 10, 4);
        return new HKey(digest, BytecodeAnalysisConverter.mkDirectionKey(direction), true, false);
    }

    @Nullable
    private static byte[] psiClassDigest(@NotNull PsiClass psiClass, @NotNull MessageDigest md) {
        String descriptor = BytecodeAnalysisConverter.descriptor(psiClass, 0, false);
        if (descriptor == null) {
            return null;
        }
        return md.digest(descriptor.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    @Nullable
    private static byte[] methodDigest(@NotNull PsiMethod psiMethod, @NotNull MessageDigest md) {
        String descriptor = BytecodeAnalysisConverter.descriptor(psiMethod);
        if (descriptor == null) {
            return null;
        }
        return md.digest(descriptor.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    @Nullable
    private static String descriptor(@NotNull PsiMethod psiMethod) {
        String desc;
        StringBuilder sb = new StringBuilder();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return null;
        }
        PsiClass outerClass = psiClass.getContainingClass();
        boolean isInnerClassConstructor = psiMethod.isConstructor() && outerClass != null && !psiClass.hasModifierProperty("static");
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        PsiType returnType = psiMethod.getReturnType();
        sb.append(returnType == null ? "<init>" : psiMethod.getName());
        sb.append('(');
        if (isInnerClassConstructor) {
            desc = BytecodeAnalysisConverter.descriptor(outerClass, 0, true);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiParameter parameter : parameters) {
            desc = BytecodeAnalysisConverter.descriptor(parameter.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        if (returnType == null) {
            sb.append('V');
        } else {
            desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions, boolean full) {
        PsiFile containingFile = psiClass.getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            ProjectBytecodeAnalysis.LOG.debug("containingFile was not resolved for " + psiClass.getQualifiedName());
            return null;
        }
        PsiClassOwner psiFile = (PsiClassOwner)containingFile;
        String packageName = psiFile.getPackageName();
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return null;
        }
        String className = packageName.length() > 0 ? qname.substring(packageName.length() + 1).replace('.', '$') : qname.replace('.', '$');
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensions; ++i) {
            sb.append('[');
        }
        if (full) {
            sb.append('L');
        }
        if (packageName.length() > 0) {
            sb.append(packageName.replace('.', '/'));
            sb.append('/');
        }
        sb.append(className);
        if (full) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure((PsiType)psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions, true);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + ((PsiClassType)psiType).getClassName());
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                sb.append('[');
            }
            if (PsiType.VOID.equals((Object)psiType)) {
                sb.append('V');
            } else if (PsiType.BOOLEAN.equals((Object)psiType)) {
                sb.append('Z');
            } else if (PsiType.CHAR.equals((Object)psiType)) {
                sb.append('C');
            } else if (PsiType.BYTE.equals((Object)psiType)) {
                sb.append('B');
            } else if (PsiType.SHORT.equals((Object)psiType)) {
                sb.append('S');
            } else if (PsiType.INT.equals((Object)psiType)) {
                sb.append('I');
            } else if (PsiType.FLOAT.equals((Object)psiType)) {
                sb.append('F');
            } else if (PsiType.LONG.equals((Object)psiType)) {
                sb.append('J');
            } else if (PsiType.DOUBLE.equals((Object)psiType)) {
                sb.append('D');
            }
            return sb.toString();
        }
        return null;
    }

    static int mkDirectionKey(Direction dir) {
        if (dir == Direction.Out) {
            return 0;
        }
        if (dir == Direction.NullableOut) {
            return 1;
        }
        if (dir == Direction.Pure) {
            return 2;
        }
        if (dir instanceof Direction.In) {
            Direction.In in = (Direction.In)dir;
            return 3 + 8 * in.paramId() + in.nullityMask;
        }
        Direction.InOut inOut = (Direction.InOut)dir;
        return 3 + 8 * inOut.paramId() + 2 + inOut.valueId();
    }

    @NotNull
    static Direction extractDirection(int directionKey) {
        if (directionKey == 0) {
            return Direction.Out;
        }
        if (directionKey == 1) {
            return Direction.NullableOut;
        }
        if (directionKey == 2) {
            return Direction.Pure;
        }
        int paramKey = directionKey - 3;
        int paramId = paramKey / 8;
        int subDirectionId = paramKey % 8;
        if (subDirectionId <= 1) {
            return new Direction.In(paramId, subDirectionId);
        }
        int valueId = subDirectionId - 2;
        return new Direction.InOut(paramId, Value.values()[valueId]);
    }

    @NotNull
    public static ArrayList<HKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull HKey primaryKey) {
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        ArrayList<HKey> keys = new ArrayList<HKey>(parameters.length * 2 + 2);
        keys.add(primaryKey);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getType() instanceof PsiPrimitiveType) continue;
            keys.add(primaryKey.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(new Direction.InOut(i, Value.NotNull))));
            keys.add(primaryKey.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(new Direction.InOut(i, Value.Null))));
        }
        return keys;
    }

    public static void addMethodAnnotations(@NotNull Map<HKey, Value> solution, @NotNull MethodAnnotations methodAnnotations, @NotNull HKey methodKey, int arity) {
        ArrayList<String> contractClauses = new ArrayList<String>(arity * 2);
        Set<HKey> notNulls = methodAnnotations.notNulls;
        Set<HKey> pures = methodAnnotations.pures;
        Map<HKey, String> contracts = methodAnnotations.contractsValues;
        for (Map.Entry<HKey, Value> entry : solution.entrySet()) {
            Value value = entry.getValue();
            if (value == Value.Top || value == Value.Bot) continue;
            HKey key = entry.getKey().mkStable();
            Direction direction = BytecodeAnalysisConverter.extractDirection(key.dirKey);
            HKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            if (value == Value.NotNull && direction == Direction.Out) {
                notNulls.add(methodKey);
                continue;
            }
            if (value == Value.Pure && direction == Direction.Pure) {
                pures.add(methodKey);
                continue;
            }
            if (!(direction instanceof Direction.InOut)) continue;
            contractClauses.add(BytecodeAnalysisConverter.contractElement(arity, (Direction.InOut)direction, value));
        }
        if (!notNulls.contains(methodKey) && !contractClauses.isEmpty()) {
            Collections.sort(contractClauses);
            StringBuilder sb = new StringBuilder("\"");
            StringUtil.join(contractClauses, (String)";", (StringBuilder)sb);
            sb.append('\"');
            contracts.put(methodKey, sb.toString().intern());
        }
    }

    public static void addEffectAnnotations(Map<HKey, Set<HEffectQuantum>> puritySolutions, MethodAnnotations result, HKey methodKey, int arity) {
        for (Map.Entry<HKey, Set<HEffectQuantum>> entry : puritySolutions.entrySet()) {
            Set<HEffectQuantum> effects = entry.getValue();
            HKey key = entry.getKey().mkStable();
            HKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey) || !effects.isEmpty()) continue;
            result.pures.add(methodKey);
        }
    }

    private static String contractValueString(@NotNull Value v) {
        switch (v) {
            case False: {
                return "false";
            }
            case True: {
                return "true";
            }
            case NotNull: {
                return "!null";
            }
            case Null: {
                return "null";
            }
        }
        return "_";
    }

    private static String contractElement(int arity, Direction.InOut inOut, Value value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arity; ++i) {
            Value currentValue = Value.Top;
            if (i == inOut.paramIndex) {
                currentValue = inOut.inValue;
            }
            if (i > 0) {
                sb.append(',');
            }
            sb.append(BytecodeAnalysisConverter.contractValueString(currentValue));
        }
        sb.append("->");
        sb.append(BytecodeAnalysisConverter.contractValueString(value));
        return sb.toString();
    }
}

