/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class InspectionListCellRenderer
extends DefaultListCellRenderer
implements MatcherHolder {
    private Matcher myMatcher;
    private final SimpleTextAttributes mySelected = new SimpleTextAttributes(UIUtil.getListSelectionBackground(), UIUtil.getListSelectionForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myPlain = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myHighlighted = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), null, 64);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
        SimpleColoredComponent group;
        InspectionToolWrapper toolWrapper;
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        JPanel panel = new JPanel(layout);
        panel.setOpaque(true);
        Color bg = sel ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
        Color fg = sel ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
        panel.setBackground(bg);
        panel.setForeground(fg);
        if (value instanceof InspectionToolWrapper) {
            boolean matchHighlighting;
            toolWrapper = (InspectionToolWrapper)value;
            String inspectionName = "  " + toolWrapper.getDisplayName();
            String groupName = StringUtil.join((String[])toolWrapper.getGroupPath(), (String)" | ");
            String matchingText = inspectionName + "|" + groupName;
            FList fragments = ((MinusculeMatcher)this.myMatcher).matchingFragments(matchingText);
            ArrayList<TextRange> adjustedFragments = new ArrayList<TextRange>();
            if (fragments != null) {
                adjustedFragments.addAll((Collection<TextRange>)fragments);
            }
            int splitPoint = InspectionListCellRenderer.adjustRanges(adjustedFragments, inspectionName.length() + 1);
            SimpleColoredComponent c = new SimpleColoredComponent();
            boolean bl = matchHighlighting = Registry.is((String)"ide.highlight.match.in.selected.only") && !sel;
            if (matchHighlighting) {
                c.append(inspectionName, this.myPlain);
            } else {
                List ranges = adjustedFragments.subList(0, splitPoint);
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)c, (String)inspectionName, ranges, (SimpleTextAttributes)(sel ? this.mySelected : this.myPlain), (SimpleTextAttributes)this.myHighlighted);
            }
            panel.add((Component)c, "West");
            group = new SimpleColoredComponent();
            if (matchHighlighting) {
                group.append(groupName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                SimpleTextAttributes attributes = sel ? this.mySelected : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                List ranges = adjustedFragments.subList(splitPoint, adjustedFragments.size());
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)group, (String)groupName, ranges, (SimpleTextAttributes)attributes, (SimpleTextAttributes)this.myHighlighted);
            }
        } else {
            return value == "non-prefix matches:" ? ChooseByNameBase.renderNonPrefixSeparatorComponent(UIUtil.getListBackground()) : super.getListCellRendererComponent((JList<?>)list, value, index, sel, focus);
        }
        JPanel right = new JPanel(new BorderLayout());
        right.setBackground(bg);
        right.setForeground(fg);
        right.add((Component)group, "Center");
        JLabel icon = new JLabel(InspectionListCellRenderer.getIcon(toolWrapper));
        icon.setBackground(bg);
        icon.setForeground(fg);
        right.add((Component)icon, "East");
        panel.add((Component)right, "East");
        return panel;
    }

    private static int adjustRanges(List<TextRange> ranges, int offset) {
        int result = 0;
        for (int i = 0; i < ranges.size(); ++i) {
            TextRange range = ranges.get(i);
            int startOffset = range.getStartOffset();
            if (startOffset < offset) {
                result = i + 1;
                continue;
            }
            ranges.set(i, new TextRange(startOffset - offset, range.getEndOffset() - offset));
        }
        return result;
    }

    @NotNull
    private static Icon getIcon(@NotNull InspectionToolWrapper tool) {
        LanguageFileType fileType;
        Icon icon = null;
        Language language = Language.findLanguageByID((String)tool.getLanguage());
        if (language != null && (fileType = language.getAssociatedFileType()) != null) {
            icon = fileType.getIcon();
        }
        if (icon == null) {
            icon = UnknownFileType.INSTANCE.getIcon();
        }
        assert (icon != null);
        return icon;
    }

    public void setPatternMatcher(Matcher matcher) {
        this.myMatcher = matcher;
    }
}

