/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.accessStaticViaInstance;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessStaticViaInstanceBase
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NonNls
    public static final String ACCESS_STATIC_VIA_INSTANCE = "AccessStaticViaInstance";

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"access.static.via.instance", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return ACCESS_STATIC_VIA_INSTANCE;
    }

    public String getAlternativeID() {
        return "static-access";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                AccessStaticViaInstanceBase.this.checkAccessStaticMemberViaInstanceReference(expression, holder, isOnTheFly);
            }
        };
    }

    private void checkAccessStaticMemberViaInstanceReference(PsiReferenceExpression expr, ProblemsHolder holder, boolean onTheFly) {
        PsiElement qualifierResolved;
        JavaResolveResult result = expr.advancedResolve(false);
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiExpression qualifierExpression = expr.getQualifierExpression();
        if (qualifierExpression == null) {
            return;
        }
        if (qualifierExpression instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return;
        }
        String description = JavaErrorMessages.message("static.member.accessed.via.instance.reference", JavaHighlightUtil.formatType(qualifierExpression.getType()), HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        if (!onTheFly && RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression, null, new ArrayList<PsiElement>())) {
            holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[0]);
            return;
        }
        holder.registerProblem((PsiElement)expr, description, new LocalQuickFix[]{this.createAccessStaticViaInstanceFix(expr, onTheFly, result)});
    }

    protected LocalQuickFix createAccessStaticViaInstanceFix(PsiReferenceExpression expr, boolean onTheFly, JavaResolveResult result) {
        return null;
    }
}

