/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiElement resolve;
                PsiType functionalInterfaceType;
                PsiMethod interfaceMethod;
                PsiType qualifierType;
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (qualifierExpression != null && referenceNameElement != null && (qualifierType = qualifierExpression.getType()) != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = expression.getFunctionalInterfaceType()))) != null && (resolve = expression.resolve()) instanceof PsiMethod && (interfaceMethod == resolve || MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)((PsiMethod)resolve))) && TypeConversionUtil.isAssignable((PsiType)functionalInterfaceType, (PsiType)qualifierType)) {
                    holder.registerProblem(referenceNameElement, "Method reference can be replaced with qualifier", new LocalQuickFix[]{new ReplaceMethodRefWithQualifierFix()});
                }
            }
        };
    }

    private static class ReplaceMethodRefWithQualifierFix
    implements LocalQuickFix {
        private ReplaceMethodRefWithQualifierFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with qualifier";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression qualifierExpression;
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof PsiMethodReferenceExpression && (qualifierExpression = ((PsiMethodReferenceExpression)parent).getQualifierExpression()) != null) {
                parent.replace((PsiElement)qualifierExpression);
            }
        }
    }
}

