/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class SuppressIntentionActionFromFix
extends SuppressIntentionAction {
    private final SuppressQuickFix myFix;

    private SuppressIntentionActionFromFix(@NotNull SuppressQuickFix fix) {
        this.myFix = fix;
    }

    @NotNull
    public static SuppressIntentionAction convertBatchToSuppressIntentionAction(@NotNull SuppressQuickFix fix) {
        return new SuppressIntentionActionFromFix(fix);
    }

    @NotNull
    public static SuppressIntentionAction[] convertBatchToSuppressIntentionActions(@NotNull SuppressQuickFix[] actions) {
        return (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])actions, SuppressIntentionAction.class, (Function)new Function<SuppressQuickFix, SuppressIntentionAction>(){

            public SuppressIntentionAction fun(SuppressQuickFix fix) {
                return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction(fix);
            }
        });
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement container = this.getContainer(element);
        boolean caretWasBeforeStatement = editor != null && container != null && editor.getCaretModel().getOffset() == container.getTextRange().getStartOffset();
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project2);
        ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(element, element, "", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
        this.myFix.applyFix(project2, (CommonProblemDescriptor)descriptor);
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container.getTextRange().getStartOffset());
        }
    }

    public ThreeState isShouldBeAppliedToInjectionHost() {
        return this.myFix instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)this.myFix).isShouldBeAppliedToInjectionHost() : ThreeState.UNSURE;
    }

    public PsiElement getContainer(PsiElement element) {
        return this.myFix instanceof ContainerBasedSuppressQuickFix ? ((ContainerBasedSuppressQuickFix)this.myFix).getContainer(element) : null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        return this.myFix.isAvailable(project2, element);
    }

    @NotNull
    public String getText() {
        return this.myFix.getName() + (this.isShouldBeAppliedToInjectionHost() == ThreeState.NO ? " in injection" : "");
    }

    @NotNull
    public String getFamilyName() {
        return this.myFix.getFamilyName();
    }
}

