/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StringTokenizerDelimiterInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String NEXT_TOKEN = "nextToken";
    private static final String STRING_TOKENIZER = "java.util.StringTokenizer";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiClass stringTokenizer;
                PsiExpressionList argumentList = callExpression.getArgumentList();
                PsiMethod method = callExpression.resolveMethod();
                if (method != null && argumentList != null && (method.isConstructor() || StringTokenizerDelimiterInspection.NEXT_TOKEN.equals(method.getName())) && (stringTokenizer = method.getContainingClass()) != null && StringTokenizerDelimiterInspection.STRING_TOKENIZER.equals(stringTokenizer.getQualifiedName())) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    int argCount = arguments.length;
                    if (method.isConstructor()) {
                        if (argCount == 2 || argCount == 3) {
                            StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[1], holder);
                        }
                    } else if (argCount == 1) {
                        StringTokenizerDelimiterInspection.hasArgumentDuplicates(arguments[0], holder);
                    }
                }
            }
        };
    }

    private static void hasArgumentDuplicates(PsiExpression delimiterArgument, ProblemsHolder holder) {
        Object value;
        if (delimiterArgument instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)delimiterArgument).getValue()) instanceof String) {
            String delimiters = (String)value;
            THashSet chars = new THashSet();
            for (char c : delimiters.toCharArray()) {
                if (chars.add(Character.valueOf(c))) continue;
                holder.registerProblem((PsiElement)delimiterArgument, "Delimiters argument contains duplicated characters", new LocalQuickFix[]{new ReplaceDelimitersWithUnique((PsiElement)delimiterArgument)});
                return;
            }
        }
    }

    private static final class ReplaceDelimitersWithUnique
    extends LocalQuickFixOnPsiElement {
        public ReplaceDelimitersWithUnique(@NotNull PsiElement element) {
            super(element);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            return "Replace StringTokenizer delimiters parameter with unique symbols";
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            LinkedHashSet<Character> uniqueChars = new LinkedHashSet<Character>();
            PsiLiteralExpression delimiterArgument = (PsiLiteralExpression)startElement;
            for (char c : ((String)delimiterArgument.getValue()).toCharArray()) {
                uniqueChars.add(Character.valueOf(c));
            }
            String newDelimiters = StringUtil.join(uniqueChars, (String)"");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
            delimiterArgument.replace((PsiElement)elementFactory.createExpressionFromText(StringUtil.wrapWithDoubleQuote((String)((String)StringUtil.escaper((boolean)true, null).fun((Object)newDelimiters))), null));
        }
    }
}

