/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.i18n.AnnotateNonNlsQuickfix");
    private final PsiAnnotation myAnnotation;
    private final PsiModifierListOwner myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        this.myAnnotation = annotation;
        this.myListOwner = listOwner;
    }

    @NotNull
    public String getName() {
        return CodeInsightBundle.message((String)"remove.annotation", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (this.myAnnotation.isPhysical()) {
            try {
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myAnnotation)) {
                    return;
                }
                this.myAnnotation.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else if (this.myListOwner != null) {
            ExternalAnnotationsManager.getInstance((Project)project2).deannotate(this.myListOwner, this.myAnnotation.getQualifiedName());
        }
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }
}

