/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaCodeBlockInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + RedundantLambdaCodeBlockInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Statement lambda can be replaced with expression lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "CodeBlock2Expr";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                PsiElement body;
                PsiExpression psiExpression;
                super.visitLambdaExpression(expression);
                if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression) && (psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant((PsiExpression)expression, body = expression.getBody())) != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body.getFirstChild();
                    holder.registerProblem(errorElement, "Statement lambda can be replaced with expression lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }
        };
    }

    public static PsiExpression isCodeBlockRedundant(PsiExpression expression, PsiElement body) {
        PsiExpression psiExpression;
        if (body instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body, psiExpression)) {
            CandidateInfo[] candidates;
            PsiElement gParent;
            PsiElement parent;
            if (LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && (candidates = PsiResolveHelper.SERVICE.getInstance((Project)gParent.getProject()).getReferencedMethodCandidates((PsiCallExpression)gParent, false, true)).length > 1) {
                ArrayList<CandidateInfo> info = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
                LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)parent);
                JavaMethodsConflictResolver conflictResolver = new JavaMethodsConflictResolver((PsiExpressionList)parent, level);
                PsiExpressionList argumentList = ((PsiCallExpression)gParent).getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                boolean atLeastOneMatchFound = conflictResolver.checkParametersNumber(info, argumentList.getExpressions().length, false);
                if (!atLeastOneMatchFound) {
                    return null;
                }
                conflictResolver.checkSpecifics(info, 2, level);
                if (info.size() > 1) {
                    return null;
                }
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body, PsiExpression psiExpression) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)comment, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getName() {
            return "Replace with expression lambda";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                PsiExpression expression;
                PsiElement body;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
                if (lambdaExpression != null && (body = lambdaExpression.getBody()) != null && (expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null) {
                    body.replace((PsiElement)expression);
                }
            }
        }
    }
}

