/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NumericOverflowInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Key<String> HAS_OVERFLOW_IN_CHILD = Key.create((String)"HAS_OVERFLOW_IN_CHILD");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.NUMERIC_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Numeric overflow";
    }

    @NotNull
    public String getShortName() {
        return "NumericOverflow";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(PsiExpression expression) {
                boolean info = NumericOverflowInspection.hasOverflow(expression, holder.getProject());
                if (info) {
                    holder.registerProblem((PsiElement)expression, JavaErrorMessages.message("numeric.overflow.in.expression", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOverflow(PsiExpression expr, @NotNull Project project2) {
        if (!TypeConversionUtil.isNumericType((PsiType)expr.getType())) {
            return false;
        }
        boolean overflow = false;
        try {
            if (expr.getUserData(HAS_OVERFLOW_IN_CHILD) == null) {
                JavaPsiFacade.getInstance((Project)project2).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr, true);
            } else {
                overflow = true;
            }
        }
        catch (ConstantEvaluationOverflowException e) {
            overflow = true;
        }
        finally {
            PsiElement parent = expr.getParent();
            if (overflow && parent instanceof PsiExpression) {
                parent.putUserData(HAS_OVERFLOW_IN_CHILD, (Object)"");
            }
        }
        return overflow;
    }
}

