/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionEngine");

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session, @NotNull List<PsiElement> elements, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        PsiElementVisitor visitor = tool.buildVisitor(holder, isOnTheFly, session);
        if (visitor == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        }
        assert (!(visitor instanceof PsiRecursiveElementVisitor) && !(visitor instanceof PsiRecursiveElementWalkingVisitor)) : "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive. " + tool;
        tool.inspectionStarted(session, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor, elementDialectIds, dialectIdsSpecifiedForTool);
        return visitor;
    }

    public static void acceptElements(@NotNull List<PsiElement> elements, @NotNull PsiElementVisitor elementVisitor, @NotNull Set<String> elementDialectIds, @Nullable(value="null means all accepted") Set<String> dialectIdsSpecifiedForTool) {
        if (dialectIdsSpecifiedForTool != null && !InspectionEngine.intersect(elementDialectIds, dialectIdsSpecifiedForTool)) {
            return;
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            element.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    private static boolean intersect(@NotNull Set<String> ids1, @NotNull Set<String> ids2) {
        if (ids1.size() > ids2.size()) {
            return InspectionEngine.intersect(ids2, ids1);
        }
        for (String id : ids1) {
            if (!ids2.contains(id)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<ProblemDescriptor> inspect(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator);
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result.addAll(group);
        }
        return result;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator) {
        if (toolWrappers.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        TextRange range = file2.getTextRange();
        Divider.divideInsideAndOutside(file2, range.getStartOffset(), range.getEndOffset(), range, elements, new ArrayList<ProperTextRange>(), Collections.emptyList(), Collections.emptyList(), true, (Condition<PsiFile>)Conditions.alwaysTrue());
        return InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, failFastOnAcquireReadAction, indicator, elements, InspectionEngine.calcElementDialectIds(elements));
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<LocalInspectionToolWrapper> toolWrappers, final @NotNull PsiFile file2, final @NotNull InspectionManager iManager, final boolean isOnTheFly, boolean failFastOnAcquireReadAction, @NotNull ProgressIndicator indicator, final @NotNull List<PsiElement> elements, final @NotNull Set<String> elementDialectIds) {
        TextRange range = file2.getTextRange();
        final LocalInspectionToolSession session = new LocalInspectionToolSession(file2, range.getStartOffset(), range.getEndOffset());
        Map<LocalInspectionToolWrapper, Set<String>> toolToSpecifiedDialectIds = InspectionEngine.getToolsToSpecifiedLanguages(toolWrappers);
        ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>> entries = new ArrayList<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(toolToSpecifiedDialectIds.entrySet());
        final ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor<Map.Entry<LocalInspectionToolWrapper, Set<String>>> processor2 = new Processor<Map.Entry<LocalInspectionToolWrapper, Set<String>>>(){

            public boolean process(Map.Entry<LocalInspectionToolWrapper, Set<String>> entry) {
                ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
                final LocalInspectionTool tool = (LocalInspectionTool)entry.getKey().getTool();
                Set<String> dialectIdsSpecifiedForTool = entry.getValue();
                InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements, elementDialectIds, dialectIdsSpecifiedForTool);
                tool.inspectionFinished(session, holder);
                if (holder.hasResults()) {
                    resultDescriptors.put(tool.getShortName(), ContainerUtil.filter((Collection)holder.getResults(), (Condition)new Condition<ProblemDescriptor>(){

                        public boolean value(ProblemDescriptor descriptor) {
                            PsiElement element = descriptor.getPsiElement();
                            return element == null || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                        }
                    }));
                }
                return true;
            }
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(entries, indicator, failFastOnAcquireReadAction, processor2);
        return resultDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)file2.getProject());
        toolWrapper.initialize(inspectionContext);
        RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, false, false, (ProgressIndicator)new EmptyProgressIndicator());
                return list;
            }
            if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
                final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                if (globalTool instanceof GlobalSimpleInspectionTool) {
                    GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                    ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                    ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                        @Nullable
                        public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                            return descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
                        }

                        public void ignoreElement(@NotNull RefEntity refEntity) {
                            throw new RuntimeException();
                        }

                        public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                            if (!(refEntity instanceof RefElement)) {
                                return;
                            }
                            PsiElement element = ((RefElement)refEntity).getElement();
                            InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, descriptors);
                        }

                        public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                            throw new RuntimeException();
                        }
                    };
                    simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                    ArrayList<ProblemDescriptor> arrayList = descriptors;
                    return arrayList;
                }
                RefElement fileRef = refManager.getReference((PsiElement)file2);
                final AnalysisScope scope = new AnalysisScope(file2);
                assert (fileRef != null);
                fileRef.accept(new RefVisitor(){

                    public void visitElement(@NotNull RefEntity elem) {
                        CommonProblemDescriptor[] elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext);
                        if (elemDescriptors != null) {
                            InspectionEngine.convertToProblemDescriptors((PsiElement)file2, elemDescriptors, descriptors);
                        }
                        for (RefEntity child : elem.getChildren()) {
                            child.accept((RefVisitor)this);
                        }
                    }
                });
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                return arrayList;
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            toolWrapper.cleanup(file2.getProject());
            inspectionContext.cleanup();
        }
        return Collections.emptyList();
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, @NotNull CommonProblemDescriptor[] commonProblemDescriptors, @NotNull List<ProblemDescriptor> descriptors) {
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)common);
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, Set<String>> getToolsToSpecifiedLanguages(@NotNull List<LocalInspectionToolWrapper> toolWrappers) {
        THashMap toolToLanguages = new THashMap();
        for (LocalInspectionToolWrapper wrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            Set<String> specifiedLangIds = InspectionEngine.getDialectIdsSpecifiedForTool(wrapper);
            toolToLanguages.put(wrapper, specifiedLangIds);
        }
        return toolToLanguages;
    }

    @Nullable(value="null means not specified")
    private static Set<String> getDialectIdsSpecifiedForTool(@NotNull LocalInspectionToolWrapper wrapper) {
        SmartHashSet result;
        String langId = wrapper.getLanguage();
        if (langId == null) {
            return null;
        }
        Language language = Language.findLanguageByID((String)langId);
        if (language != null) {
            List dialects = language.getDialects();
            boolean applyToDialects = wrapper.applyToDialects();
            result = applyToDialects && !dialects.isEmpty() ? new THashSet(1 + dialects.size()) : new SmartHashSet();
            result.add(langId);
            if (applyToDialects) {
                for (Language dialect : dialects) {
                    result.add(dialect.getID());
                }
            }
        } else {
            result = Collections.singleton(langId);
        }
        return result;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> inside, @NotNull List<PsiElement> outside) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(inside, (Set<Language>)processedLanguages, (Set<String>)dialectIds);
        InspectionEngine.addDialects(outside, (Set<Language>)processedLanguages, (Set<String>)dialectIds);
        return dialectIds;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<PsiElement> elements) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(elements, (Set<Language>)processedLanguages, (Set<String>)dialectIds);
        return dialectIds;
    }

    private static void addDialects(@NotNull List<PsiElement> elements, @NotNull Set<Language> processedLanguages, @NotNull Set<String> dialectIds) {
        for (PsiElement element : elements) {
            Language language = element.getLanguage();
            dialectIds.add(language.getID());
            if (!processedLanguages.add(language)) continue;
            for (Language dialect : language.getDialects()) {
                dialectIds.add(dialect.getID());
            }
        }
    }
}

