/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitTypeCanBeDiamondInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + ExplicitTypeCanBeDiamondInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Explicit type can be replaced with <>";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2Diamond";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                if (PsiDiamondTypeUtil.canCollapseToDiamond(expression, expression, null)) {
                    PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference != null);
                    PsiReferenceParameterList parameterList = classReference.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    PsiElement firstChild = parameterList.getFirstChild();
                    PsiElement lastChild = parameterList.getLastChild();
                    TextRange range = new TextRange(firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.LT ? 1 : 0, parameterList.getTextLength() - (lastChild != null && lastChild.getNode().getElementType() == JavaTokenType.GT ? 1 : 0));
                    holder.registerProblem((PsiElement)parameterList, "Explicit type argument #ref #loc can be replaced with <>", ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new ReplaceWithDiamondFix()});
                }
            }
        };
    }

    private static class ReplaceWithDiamondFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithDiamondFix() {
        }

        @NotNull
        public String getName() {
            return "Replace with <>";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)PsiDiamondTypeUtil.replaceExplicitWithDiamond(element), PsiNewExpression.class);
            if (newExpression != null) {
                CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)newExpression);
            }
        }
    }
}

