/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BlockMarkerCommentsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final PsiJavaElementPattern ANONYMOUS_CLASS_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiDeclarationStatement.class, PsiExpressionStatement.class}))).afterSiblingSkipping(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiWhiteSpace.class), PsiJavaPatterns.psiElement(PsiJavaToken.class).with((PatternCondition)new PatternCondition<PsiJavaToken>(null){

        public boolean accepts(@NotNull PsiJavaToken psiJavaToken, ProcessingContext context) {
            return psiJavaToken.getTokenType().equals(JavaTokenType.SEMICOLON);
        }
    })}), (ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLocalVariable.class, PsiAssignmentExpression.class}).withChild((ElementPattern)PsiJavaPatterns.psiElement(PsiNewExpression.class).withChild((ElementPattern)PsiJavaPatterns.psiElement(PsiAnonymousClass.class))));
    private static final PsiJavaElementPattern CLASS_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiClass.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiJavaToken.class).with((PatternCondition)new PatternCondition<PsiJavaToken>(null){

        public boolean accepts(@NotNull PsiJavaToken token, ProcessingContext context) {
            return JavaTokenType.RBRACE.equals(token.getTokenType());
        }
    }));
    private static final PsiJavaElementPattern TRY_CATCH_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiTryStatement.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiCodeBlock.class, PsiCatchSection.class}));
    private static final PsiJavaElementPattern LOOP_OR_IF_MARKER = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class))).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiBlockStatement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLoopStatement.class, PsiIfStatement.class})));
    private static final PsiJavaElementPattern METHOD_MARKER_PATTERN = (PsiJavaElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiMethod.class)).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class));
    private static final ElementPattern MARKER_PATTERN = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{ANONYMOUS_CLASS_MARKER_PATTERN, CLASS_MARKER_PATTERN, TRY_CATCH_MARKER_PATTERN, LOOP_OR_IF_MARKER, METHOD_MARKER_PATTERN});
    private static final String END_WORD = "end";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitComment(PsiComment element) {
                String commentText;
                IElementType tokenType = element.getTokenType();
                if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT)) {
                    return;
                }
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
                String rawCommentText = element.getText();
                String prefix = commenter.getLineCommentPrefix();
                if (prefix != null && rawCommentText.startsWith(prefix)) {
                    rawCommentText = rawCommentText.substring(prefix.length());
                }
                if (!(commentText = rawCommentText.trim().toLowerCase()).startsWith(BlockMarkerCommentsInspection.END_WORD) || StringUtil.split((String)commentText, (String)" ").size() > 3) {
                    return;
                }
                if (MARKER_PATTERN.accepts((Object)element)) {
                    holder.registerProblem((PsiElement)element, "Redundant block marker", new LocalQuickFix[]{new LocalQuickFix(){

                        @NotNull
                        public String getName() {
                            return this.getFamilyName();
                        }

                        @NotNull
                        public String getFamilyName() {
                            return "Remove block marker comments";
                        }

                        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                            descriptor.getPsiElement().delete();
                        }
                    }});
                }
            }
        };
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Block marker comment";
    }
}

