/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressAllForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByJavaCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressLocalWithCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressParameterFix;
import com.intellij.codeInspection.BatchSuppressManager;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchSuppressManagerImpl
implements BatchSuppressManager {
    @NotNull
    public SuppressQuickFix[] createBatchSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        return new SuppressQuickFix[]{new SuppressByJavaCommentFix(displayKey), new SuppressLocalWithCommentFix(displayKey), new SuppressParameterFix(displayKey), new SuppressFix(displayKey), new SuppressForClassFix(displayKey), new SuppressAllForClassFix()};
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public PsiElement getElementMemberSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getElementMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getAnnotationMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getDocCommentToolSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getDocCommentToolSuppressedIn(owner, inspectionToolID);
    }

    @NotNull
    public Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        return JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(owner);
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file2) {
        return JavaSuppressionUtil.canHave15Suppressions(file2);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        return JavaSuppressionUtil.alreadyHas14Suppressions(commentOwner);
    }
}

