/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class TryWithResourcesPostfixTemplate
extends PostfixTemplate {
    protected TryWithResourcesPostfixTemplate() {
        super("twr", "try(Type f = new Type()) catch (Exception e)");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement element, @NotNull Document copyDocument, int newOffset) {
        Project project2;
        JavaPsiFacade facade;
        PsiClass autoCloseable;
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiExpression initializer = JavaPostfixTemplatesUtils.getTopmostExpression(element);
        if (initializer == null) {
            return false;
        }
        PsiType type = initializer.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(autoCloseable = (facade = JavaPsiFacade.getInstance((Project)(project2 = element.getProject()))).findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope((Project)project2))), (boolean)true);
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiExpression expression = JavaPostfixTemplatesUtils.getTopmostExpression(context);
        assert (expression != null);
        Project project2 = context.getProject();
        editor.getDocument().deleteString(expression.getTextRange().getStartOffset(), expression.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance(project2);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("try (");
        MacroCallNode name = new MacroCallNode(new SuggestVariableNameMacro());
        template.addVariable("type", new TypeExpression(project2, new PsiType[]{expression.getType()}), false);
        template.addTextSegment(" ");
        template.addVariable("name", name, name, true);
        template.addTextSegment(" = ");
        template.addVariable("variable", (Expression)new TextExpression(expression.getText()), false);
        template.addTextSegment(") {\n");
        template.addEndVariable();
        template.addTextSegment("\n}");
        Collection<PsiClassType> unhandled = TryWithResourcesPostfixTemplate.getUnhandled(expression);
        for (PsiClassType exception : unhandled) {
            MacroCallNode variable = new MacroCallNode(new SuggestVariableNameMacro());
            template.addTextSegment("catch(");
            template.addVariable("type " + exception.getClassName(), new TypeExpression(project2, new PsiType[]{exception}), false);
            template.addTextSegment(" ");
            template.addVariable("name " + exception.getClassName(), variable, variable, false);
            template.addTextSegment(") {}");
        }
        manager.startTemplate(editor, template);
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandled(@NotNull PsiExpression expression) {
        assert (expression.getType() != null);
        PsiMethod methodCloser = PsiUtil.getResourceCloserMethodForType((PsiClassType)((PsiClassType)expression.getType()));
        PsiSubstitutor substitutor = PsiUtil.resolveGenericsClassInType((PsiType)expression.getType()).getSubstitutor();
        return methodCloser != null ? ExceptionUtil.getUnhandledExceptions(methodCloser, (PsiElement)expression, null, substitutor) : Collections.emptyList();
    }
}

