/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplatesUtils {
    private PostfixTemplatesUtils() {
    }

    @Nullable
    public static TextRange surround(@NotNull Surrounder surrounder, @NotNull Editor editor, @NotNull PsiElement expr) {
        Project project2 = expr.getProject();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project2, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project2, editor);
        return null;
    }

    public static void showErrorHint(@NotNull Project project2, @NotNull Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Can't expand postfix template", (String)"Can't expand postfix template", (String)"");
    }

    @NotNull
    public static String getLangForProvider(@NotNull PostfixTemplateProvider provider) {
        LanguageExtensionPoint[] extensions;
        for (LanguageExtensionPoint extension : extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions()) {
            if (!provider.equals(extension.getInstance())) continue;
            return extension.getKey();
        }
        return Language.ANY.getID();
    }
}

