/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PostfixTemplateWithExpressionSelector
extends PostfixTemplate {
    @NotNull
    private final PostfixTemplateExpressionSelector mySelector;

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String key, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        super(name, key, example);
        this.mySelector = selector;
    }

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        super(name, example);
        this.mySelector = selector;
    }

    @Override
    public final boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        return this.mySelector.hasExpression(context, copyDocument, newOffset);
    }

    @Override
    public final void expand(@NotNull PsiElement context, final @NotNull Editor editor) {
        List<PsiElement> expressions = this.mySelector.getExpressions(context, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
            return;
        }
        if (expressions.size() == 1) {
            this.expandForChooseExpression(expressions.get(0), editor);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement item = (PsiElement)ContainerUtil.getLastItem(expressions);
            assert (item != null);
            this.expandForChooseExpression(item, editor);
            return;
        }
        IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiElement>(){

            public void pass(final @NotNull PsiElement e) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(e.getProject(), new Runnable(){

                            @Override
                            public void run() {
                                PostfixTemplateWithExpressionSelector.this.expandForChooseExpression(e, editor);
                            }
                        }, "Expand postfix template", (Object)"POSTFIX_TEMPLATE_ID");
                    }
                });
            }
        }, this.mySelector.getRenderer(), "Expressions", 0, ScopeHighlighter.NATURAL_RANGER);
    }

    protected abstract void expandForChooseExpression(@NotNull PsiElement var1, @NotNull Editor var2);
}

