/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplatesCheckboxTree
extends CheckboxTree {
    @NotNull
    private final CheckedTreeNode myRoot;
    @NotNull
    private final DefaultTreeModel myModel = (DefaultTreeModel)this.getModel();

    public PostfixTemplatesCheckboxTree() {
        super(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value;
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                boolean isPostfixTemplate = node instanceof PostfixTemplateCheckedTreeNode;
                SimpleTextAttributes attributes = isPostfixTemplate ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                this.getTextRenderer().append(StringUtil.notNullize((String)value.toString()), new SimpleTextAttributes(background, attributes.getFgColor(), (Color)JBColor.RED, attributes.getStyle()));
                if (isPostfixTemplate) {
                    this.getTextRenderer().append(" (" + ((PostfixTemplateCheckedTreeNode)node).getTemplate().getExample() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }, new CheckedTreeNode(null));
        this.myRoot = (CheckedTreeNode)this.myModel.getRoot();
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent event) {
                PostfixTemplatesCheckboxTree.this.selectionChanged();
            }
        });
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    protected void selectionChanged() {
    }

    public void initTree(@NotNull MultiMap<String, PostfixTemplate> langToTemplates) {
        this.myRoot.removeAllChildren();
        for (Map.Entry entry : langToTemplates.entrySet()) {
            String id = (String)entry.getKey();
            Language language = Language.findLanguageByID((String)id);
            String langName = language != null ? language.getDisplayName() : id;
            CheckedTreeNode langNode = new CheckedTreeNode((Object)langName);
            this.myRoot.add((MutableTreeNode)langNode);
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                PostfixTemplateCheckedTreeNode templateNode = new PostfixTemplateCheckedTreeNode(template, langName);
                langNode.add((MutableTreeNode)((Object)templateNode));
            }
        }
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        TreeUtil.expandAll((JTree)((Object)this));
        this.setSelectionRow(0);
    }

    public PostfixTemplate getTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null || !(path.getLastPathComponent() instanceof PostfixTemplateCheckedTreeNode)) {
            return null;
        }
        return ((PostfixTemplateCheckedTreeNode)((Object)path.getLastPathComponent())).getTemplate();
    }

    public Map<String, Set<String>> getState() {
        final HashMap result = ContainerUtil.newHashMap();
        Consumer<PostfixTemplateCheckedTreeNode> consumer = new Consumer<PostfixTemplateCheckedTreeNode>(){

            public void consume(PostfixTemplateCheckedTreeNode template) {
                if (!template.isChecked()) {
                    Set templatesForLanguage = (Set)ContainerUtil.getOrCreate((Map)result, (Object)template.getLang(), PostfixTemplatesSettings.SET_FACTORY);
                    templatesForLanguage.add(template.getTemplate().getKey());
                }
            }
        };
        this.visit(consumer);
        return result;
    }

    private void visit(@NotNull Consumer<PostfixTemplateCheckedTreeNode> consumer) {
        Enumeration languages = this.myRoot.children();
        while (languages.hasMoreElements()) {
            CheckedTreeNode langNode = (CheckedTreeNode)languages.nextElement();
            Enumeration templates = langNode.children();
            while (templates.hasMoreElements()) {
                PostfixTemplateCheckedTreeNode template = (PostfixTemplateCheckedTreeNode)((Object)templates.nextElement());
                consumer.consume((Object)template);
            }
        }
    }

    public void setState(final @NotNull Map<String, Set<String>> langToDisabledTemplates) {
        TreeState treeState = TreeState.createOn((JTree)((Object)this), (DefaultMutableTreeNode)this.myRoot);
        Consumer<PostfixTemplateCheckedTreeNode> consumer = new Consumer<PostfixTemplateCheckedTreeNode>(){

            public void consume(PostfixTemplateCheckedTreeNode template) {
                Set disabledTemplates = (Set)langToDisabledTemplates.get(template.getLang());
                String key = template.getTemplate().getKey();
                if (disabledTemplates != null && disabledTemplates.contains(key)) {
                    template.setChecked(false);
                    return;
                }
                template.setChecked(true);
            }
        };
        this.visit(consumer);
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        treeState.applyTo((JTree)((Object)this));
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void selectTemplate(final @NotNull PostfixTemplate postfixTemplate, final @NotNull String lang) {
        Consumer<PostfixTemplateCheckedTreeNode> consumer = new Consumer<PostfixTemplateCheckedTreeNode>(){

            public void consume(PostfixTemplateCheckedTreeNode template) {
                if (lang.equals(template.getLang()) && postfixTemplate.getKey().equals(template.getTemplate().getKey())) {
                    TreeUtil.selectInTree((DefaultMutableTreeNode)((Object)template), (boolean)true, (JTree)((Object)PostfixTemplatesCheckboxTree.this), (boolean)true);
                }
            }
        };
        this.visit(consumer);
    }

    private static final class PostfixTemplateCheckedTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final String myLang;
        @NotNull
        private final PostfixTemplate myTemplate;
        @NotNull
        private final PostfixTemplatesSettings mySettings;

        @NotNull
        public PostfixTemplate getTemplate() {
            return this.myTemplate;
        }

        @NotNull
        public String getLang() {
            return this.myLang;
        }

        PostfixTemplateCheckedTreeNode(@NotNull PostfixTemplate template, @NotNull String lang) {
            super((Object)template.getKey().replaceFirst("\\.", ""));
            PostfixTemplatesSettings templatesSettings = PostfixTemplatesSettings.getInstance();
            assert (templatesSettings != null);
            this.mySettings = templatesSettings;
            this.setChecked(this.mySettings.isTemplateEnabled(template, lang));
            this.myLang = lang;
            this.myTemplate = template;
        }
    }
}

