/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class PostfixTemplatesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    PostfixTemplatesCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        Editor editor = parameters.getEditor();
        if (!PostfixTemplatesCompletionProvider.isCompletionEnabled(parameters) || LiveTemplateCompletionContributor.shouldShowAllTemplates() || editor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        PsiFile originalFile = parameters.getOriginalFile();
        PostfixLiveTemplate postfixLiveTemplate = PostfixTemplateCompletionContributor.getPostfixLiveTemplate(originalFile, editor);
        if (postfixLiveTemplate != null) {
            postfixLiveTemplate.addCompletions(parameters, result.withPrefixMatcher((PrefixMatcher)new MyPrefixMatcher(result.getPrefixMatcher().getPrefix())));
            String possibleKey = postfixLiveTemplate.computeTemplateKeyWithoutContextChecking(new CustomTemplateCallback(editor, originalFile));
            if (possibleKey != null) {
                result = result.withPrefixMatcher(possibleKey);
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().oneOf(postfixLiveTemplate.getAllTemplateKeys(originalFile, parameters.getOffset())));
            }
        }
    }

    private static boolean isCompletionEnabled(@NotNull CompletionParameters parameters) {
        if (!parameters.isAutoPopup()) {
            return false;
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplatesCompletionEnabled();
    }

    private static class MyPrefixMatcher
    extends PrefixMatcher {
        protected MyPrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name) {
            return name.equalsIgnoreCase(this.myPrefix);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            return new MyPrefixMatcher(prefix);
        }
    }
}

