/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplateLookupElement
extends CustomLiveTemplateLookupElement {
    @NotNull
    private final PostfixTemplate myTemplate;
    @NotNull
    private final PostfixTemplateProvider myProvider;

    public PostfixTemplateLookupElement(@NotNull PostfixLiveTemplate liveTemplate, @NotNull PostfixTemplate postfixTemplate, @NotNull String templateKey, @NotNull PostfixTemplateProvider provider, boolean sudden) {
        super(liveTemplate, templateKey, StringUtil.trimStart((String)templateKey, (String)"."), postfixTemplate.getDescription(), sudden, true);
        this.myTemplate = postfixTemplate;
        this.myProvider = provider;
    }

    @NotNull
    public PostfixTemplate getPostfixTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public PostfixTemplateProvider getProvider() {
        return this.myProvider;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        if (this.sudden) {
            presentation.setTailText(" " + UIUtil.rightArrow() + " " + this.myTemplate.getExample());
        } else {
            presentation.setTypeText(this.myTemplate.getExample());
            presentation.setTypeGrayed(true);
        }
    }
}

