/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithTemplateHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        DefaultActionGroup group = SurroundWithTemplateHandler.createActionGroup(project2, editor, file2);
        if (group == null) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message((String)"templates.select.template.chooser.title", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
        popup.showInBestPositionFor(editor);
    }

    @Nullable
    public static DefaultActionGroup createActionGroup(Project project2, Editor editor, PsiFile file2) {
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
            if (!editor.getSelectionModel().hasSelection()) {
                return null;
            }
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        List<CustomLiveTemplate> customTemplates = TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, true);
        List<TemplateImpl> templates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(editor, file2, true);
        if (templates.isEmpty() && customTemplates.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"templates.surround.no.defined", (Object[])new Object[0]));
            return null;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return null;
        }
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        DefaultActionGroup group = new DefaultActionGroup();
        for (TemplateImpl template : templates) {
            group.add((AnAction)new InvokeTemplateAction(template, editor, project2, usedMnemonicsSet));
        }
        for (CustomLiveTemplate customTemplate : customTemplates) {
            group.add((AnAction)new WrapWithCustomTemplateAction(customTemplate, editor, file2, usedMnemonicsSet));
        }
        return group;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

