/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LiveTemplateLookupElement
extends LookupElement {
    private final String myLookupString;
    public final boolean sudden;
    private final boolean myWorthShowingInAutoPopup;
    private final String myDescription;

    public LiveTemplateLookupElement(@NotNull String lookupString, @Nullable String description, boolean sudden, boolean worthShowingInAutoPopup) {
        this.myDescription = description;
        this.sudden = sudden;
        this.myLookupString = lookupString;
        this.myWorthShowingInAutoPopup = worthShowingInAutoPopup;
    }

    @NotNull
    public String getLookupString() {
        return this.myLookupString;
    }

    @NotNull
    protected String getItemText() {
        return this.myLookupString;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        char shortcut = this.getTemplateShortcut();
        presentation.setItemText(this.getItemText());
        if (this.sudden) {
            presentation.setItemTextBold(true);
            if (!presentation.isReal() || !((RealLookupElementPresentation)presentation).isLookupSelectionTouched()) {
                if (shortcut == 'D') {
                    shortcut = TemplateSettings.getInstance().getDefaultShortcutChar();
                }
                if (shortcut != 'C') {
                    presentation.setTypeText("  [" + KeyEvent.getKeyText(shortcut) + "] ");
                } else {
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ExpandLiveTemplateCustom"));
                    if (StringUtil.isNotEmpty((String)shortcutText)) {
                        presentation.setTypeText("  [" + shortcutText + "] ");
                    }
                }
            }
            if (StringUtil.isNotEmpty((String)this.myDescription)) {
                presentation.setTailText(" (" + this.myDescription + ")", true);
            }
        } else {
            presentation.setTypeText(this.myDescription);
        }
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
    }

    public boolean isWorthShowingInAutoPopup() {
        return this.myWorthShowingInAutoPopup;
    }

    public abstract char getTemplateShortcut();
}

