/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.openapi.util.text.LineTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnaryMulOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myOperand;

    public UnaryMulOperationNode(ZenCodingNode operand) {
        this.myOperand = operand;
    }

    public ZenCodingNode getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        if (surroundedText == null) {
            return this.myOperand.expand(numberInIteration, totalIterations, null, callback, insertSurroundedTextAtTheEnd, parent);
        }
        String[] lines = LineTokenizer.tokenize((CharSequence)surroundedText, (boolean)false);
        ArrayList<GenerationNode> result = new ArrayList<GenerationNode>();
        for (int i = 0; i < lines.length; ++i) {
            result.addAll(this.myOperand.expand(i, lines.length, lines[i].trim(), callback, insertSurroundedTextAtTheEnd, parent));
        }
        return result;
    }

    @Override
    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback) {
        return this.myOperand.getApproximateOutputLength(callback);
    }

    public String toString() {
        return "*";
    }
}

