/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        String s = this.toString(token, hasChildren, context);
        TemplateImpl tokenTemplate = token.getTemplate();
        assert (tokenTemplate != null);
        TemplateImpl template = tokenTemplate.copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key) {
        StringBuilder builder = new StringBuilder("<");
        builder.append(key).append('>');
        if (!HtmlUtil.isSingleHtmlTag(key)) {
            builder.append("$END$</").append(key).append('>');
        }
        return new TemplateImpl("", builder.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        XmlTag tag;
        XmlFile file2 = token.getFile();
        XmlDocument document = file2.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            return XmlZenCodingGenerator.replaceQuotesIfNeeded(this.toString(tag, token.getAttributes(), hasChildren, context), context.getContainingFile());
        }
        return XmlZenCodingGenerator.replaceQuotesIfNeeded(file2.getText(), context.getContainingFile());
    }

    private static String replaceQuotesIfNeeded(@NotNull String text, @NotNull PsiFile file2) {
        PsiElement context = file2.getContext();
        if (context != null && context.getText().startsWith("\"")) {
            text = text.replace('\"', '\'');
        }
        return text;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull Map<String, String> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull Map<String, String> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = Math.min(editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(currentOffset)), currentOffset);
        CharSequence documentText = editor.getDocument().getCharsSequence();
        PsiElement prevVisibleLeaf = callback.getContext();
        while (prevVisibleLeaf != null) {
            TextRange textRange = prevVisibleLeaf.getTextRange();
            int endOffset = textRange.getEndOffset();
            if (endOffset <= currentOffset) {
                if (endOffset <= startOffset) break;
                IElementType prevType = prevVisibleLeaf.getNode().getElementType();
                if (prevType == XmlTokenType.XML_TAG_END || prevType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    startOffset = endOffset;
                    break;
                }
            }
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        if (startOffset < 0 || currentOffset > documentText.length() || currentOffset < startOffset) {
            Logger.getInstance(this.getClass()).error("Error while calculating emmet abbreviation. Offset: " + currentOffset + "; Start: " + startOffset, new Attachment[]{AttachmentFactory.createAttachment(editor.getDocument())});
            return null;
        }
        String key = this.computeKey(documentText.subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key) && ZenCodingTemplate.checkTemplateKey(key, callback, this) ? key : null;
    }

    @Override
    public void disableEmmet() {
        EmmetOptions.getInstance().setEmmetEnabled(false);
    }

    @Override
    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        return ZenCodingUtil.isHtml(callback);
    }
}

