/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TrimZenCodingFilter
extends ZenCodingFilter {
    private static final Pattern PATTERN = Pattern.compile("^([\\s|\u00a0])?[\\d|#|\\-|\\*|\u2022]+\\.?\\s*");

    @Override
    @NotNull
    public String getSuffix() {
        return "t";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Trim line markers";
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        XmlDocument document = token.getFile().getDocument();
        if (document != null) {
            XmlTag tag = document.getRootTag();
            if (tag != null && !tag.getText().isEmpty()) {
                tag.accept((PsiElementVisitor)new XmlElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        if (!tag.isEmpty()) {
                            final XmlTagValue tagValue = tag.getValue();
                            final Matcher matcher = PATTERN.matcher(tagValue.getText());
                            if (matcher.matches()) {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        tagValue.setText(matcher.replaceAll(""));
                                    }
                                });
                            }
                        }
                        tag.acceptChildren((PsiElementVisitor)this);
                    }
                });
                return tag.getText();
            }
            return PATTERN.matcher(document.getText()).replaceAll("");
        }
        return text;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        TrimZenCodingFilter.doFilter(node);
        return node;
    }

    private static void doFilter(GenerationNode node) {
        String surroundedText = node.getSurroundedText();
        if (surroundedText != null) {
            node.setSurroundedText(PATTERN.matcher(surroundedText).replaceAll(""));
        }
        for (GenerationNode child : node.getChildren()) {
            TrimZenCodingFilter.doFilter(child);
        }
    }
}

