/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import org.apache.xerces.util.XML11Char;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingUtil {
    private static final char NUMBER_IN_ITERATION_PLACE_HOLDER = '$';
    private static final String SURROUNDED_TEXT_MARKER = "$#";

    private ZenCodingUtil() {
    }

    public static boolean containsSurroundedTextMarker(@NotNull String s) {
        return s.contains(SURROUNDED_TEXT_MARKER);
    }

    public static String replaceMarkers(String s, int numberInIteration, int totalIterations, @Nullable String surroundedText) {
        String by = Integer.toString(numberInIteration + 1);
        StringBuilder builder = new StringBuilder(s.length());
        int markerStartIndex = -1;
        int n = s.length();
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i < n ? s.charAt(i) : (char)'\u0000';
            if (c == '\\' && i < n - 1) {
                builder.append(s.charAt(++i));
                continue;
            }
            if (c == '$' && (i == n - 1 || s.charAt(i + 1) != '#')) {
                if (markerStartIndex != -1) continue;
                markerStartIndex = i;
                continue;
            }
            int markersCount = i - markerStartIndex;
            if (markerStartIndex != -1) {
                boolean decrement = false;
                if (i < n && s.charAt(i) == '@') {
                    if (++i < n && s.charAt(i) == '-') {
                        decrement = true;
                        ++i;
                    }
                    StringBuilder base = new StringBuilder();
                    while (i < n && Character.isDigit(s.charAt(i))) {
                        base.append(s.charAt(i));
                        ++i;
                    }
                    int baseInt = StringUtil.parseInt((String)base.toString(), (int)0) - 1;
                    int n2 = baseInt = baseInt >= 0 ? baseInt : 0;
                    if (baseInt >= 0) {
                        int byInt = decrement ? totalIterations - numberInIteration : numberInIteration + 1;
                        by = Integer.toString(byInt += baseInt);
                    }
                }
                int m = markersCount - by.length();
                for (int k = 0; k < m; ++k) {
                    builder.append('0');
                }
                builder.append(by);
                markerStartIndex = -1;
                char c3 = c = i < n ? s.charAt(i) : (char)'\u0000';
            }
            if (i >= n) continue;
            if (c == '$' && surroundedText != null) {
                builder.append(surroundedText);
                ++i;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String getValue(String value, int numberInIteration, int totalIterations, String surroundedText) {
        String s = ZenCodingUtil.replaceMarkers(value, numberInIteration, totalIterations, surroundedText);
        return s.replace("\"", "&quot;");
    }

    public static boolean isXML11ValidQName(String str) {
        int colon = str.indexOf(58);
        if (colon == 0 || colon == str.length() - 1) {
            return false;
        }
        if (colon > 0) {
            String prefix = str.substring(0, colon);
            String localPart = str.substring(colon + 1);
            return XML11Char.isXML11ValidNCName((String)prefix) && XML11Char.isXML11ValidNCName((String)localPart);
        }
        return XML11Char.isXML11ValidNCName((String)str);
    }

    public static boolean isHtml(CustomTemplateCallback callback) {
        FileType type = callback.getFileType();
        return type == StdFileTypes.HTML || type == StdFileTypes.XHTML;
    }

    public static boolean checkFilterSuffix(@NotNull String suffix) {
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!suffix.equals(generator.getSuffix())) continue;
            return true;
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!suffix.equals(filter.getSuffix())) continue;
            return true;
        }
        return false;
    }
}

