/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.Variable;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Template {
    private static final Map<Property, Boolean> DEFAULT_PROPERTIES = new EnumMap<Property, Boolean>(Property.class);
    private final Map<Property, Boolean> myProperties = new EnumMap<Property, Boolean>(Property.class);

    public abstract void addTextSegment(@NotNull String var1);

    public abstract void addVariableSegment(@NonNls @NotNull String var1);

    public Variable addVariable(@NonNls @NotNull String name, @NotNull Expression defaultValueExpression, boolean isAlwaysStopAt) {
        return this.addVariable(name, defaultValueExpression, defaultValueExpression, isAlwaysStopAt);
    }

    public abstract Variable addVariable(Expression var1, boolean var2);

    public Variable addVariable(@NonNls @NotNull String name, Expression expression, Expression defaultValueExpression, boolean isAlwaysStopAt) {
        return this.addVariable(name, expression, defaultValueExpression, isAlwaysStopAt, false);
    }

    public abstract Variable addVariable(@NonNls @NotNull String var1, Expression var2, Expression var3, boolean var4, boolean var5);

    public abstract Variable addVariable(@NonNls @NotNull String var1, @NonNls String var2, @NonNls String var3, boolean var4);

    public abstract void addEndVariable();

    public abstract void addSelectionStartVariable();

    public abstract void addSelectionEndVariable();

    public abstract String getId();

    public abstract String getKey();

    @Nullable
    public abstract String getDescription();

    public abstract boolean isToReformat();

    public abstract void setToReformat(boolean var1);

    public abstract void setToIndent(boolean var1);

    public abstract void setInline(boolean var1);

    public abstract int getSegmentsCount();

    public abstract String getSegmentName(int var1);

    public abstract int getSegmentOffset(int var1);

    @NotNull
    public abstract String getString();

    @NotNull
    public abstract String getTemplateText();

    public abstract boolean isToShortenLongNames();

    public abstract void setToShortenLongNames(boolean var1);

    public boolean getValue(@NotNull Property key) {
        Boolean result = this.myProperties.get((Object)key);
        return result == null ? Template.getDefaultValue(key) : result;
    }

    public void setValue(@NotNull Property key, boolean value) {
        this.myProperties.put(key, value);
    }

    public static boolean getDefaultValue(@NotNull Property key) {
        Boolean result = DEFAULT_PROPERTIES.get((Object)key);
        return result == null ? false : result;
    }

    static {
        DEFAULT_PROPERTIES.put(Property.USE_STATIC_IMPORT_IF_POSSIBLE, false);
    }

    public static enum Property {
        USE_STATIC_IMPORT_IF_POSSIBLE;

    }
}

