/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateBuilder {
    @NonNls
    private static final String END_PREFIX = "____END";
    private static final Logger LOGGER = Logger.getInstance(LiveTemplateBuilder.class);
    private final StringBuilder myText = new StringBuilder();
    private final List<Variable> myVariables = new ArrayList<Variable>();
    private final Set<String> myVarNames = new HashSet();
    private final List<VarOccurence> myVariableOccurrences = new ArrayList<VarOccurence>();
    private final List<Marker> myMarkers = new ArrayList<Marker>();
    private final int mySegmentLimit;
    private final boolean myAddEndVariableAtTheEndOfTemplate;
    private String myLastEndVarName;
    private boolean myIsToReformat = false;

    public LiveTemplateBuilder() {
        this(false, Registry.intValue((String)"emmet.segments.limit"));
    }

    public LiveTemplateBuilder(boolean addEndVariableAtTheEndOfTemplate, int segmentLimit) {
        this.mySegmentLimit = segmentLimit;
        this.myAddEndVariableAtTheEndOfTemplate = addEndVariableAtTheEndOfTemplate;
    }

    public void setIsToReformat(boolean isToReformat) {
        this.myIsToReformat = isToReformat;
    }

    public CharSequence getText() {
        return this.myText;
    }

    public static boolean isEndVariable(@NotNull String name) {
        return name.startsWith(END_PREFIX);
    }

    public boolean findVarOccurence(String name) {
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (!occurence.myName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public TemplateImpl buildTemplate() {
        List<Variable> variables = this.getListWithLimit(this.myVariables);
        if (!this.findVarOccurence("END")) {
            if (this.myLastEndVarName == null) {
                for (Variable variable : variables) {
                    if (!LiveTemplateBuilder.isEndVariable(variable.getName())) continue;
                    this.myLastEndVarName = variable.getName();
                    break;
                }
            }
            if (this.myLastEndVarName != null) {
                int endOffset = -1;
                if (this.myAddEndVariableAtTheEndOfTemplate) {
                    endOffset = this.myText.length();
                } else {
                    Iterator<Object> it = this.myVariableOccurrences.iterator();
                    while (it.hasNext()) {
                        VarOccurence occurence = (VarOccurence)it.next();
                        if (!occurence.myName.equals(this.myLastEndVarName)) continue;
                        endOffset = occurence.myOffset;
                        break;
                    }
                    if (endOffset >= 0) {
                        Iterator<Variable> it1 = variables.iterator();
                        while (it1.hasNext()) {
                            Variable variable = it1.next();
                            if (!this.myLastEndVarName.equals(variable.getName()) || !variable.isAlwaysStopAt()) continue;
                            it.remove();
                            it1.remove();
                        }
                    }
                }
                if (endOffset >= 0) {
                    this.myVariableOccurrences.add(new VarOccurence("END", endOffset));
                }
            }
        }
        TemplateImpl template = new TemplateImpl("", "");
        for (Variable variable : variables) {
            template.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
        List<VarOccurence> variableOccurrences = this.getListWithLimit(this.myVariableOccurrences);
        Collections.sort(variableOccurrences, new Comparator<VarOccurence>(){

            @Override
            public int compare(@NotNull VarOccurence o1, @NotNull VarOccurence o2) {
                if (o1.myOffset < o2.myOffset) {
                    return -1;
                }
                if (o1.myOffset > o2.myOffset) {
                    return 1;
                }
                return 0;
            }
        });
        int last = 0;
        for (VarOccurence occurence : variableOccurrences) {
            template.addTextSegment(this.myText.substring(last, occurence.myOffset));
            template.addVariableSegment(occurence.myName);
            last = occurence.myOffset;
        }
        template.addTextSegment(this.myText.substring(last));
        template.setToReformat(this.myIsToReformat);
        return template;
    }

    private <T> List<T> getListWithLimit(List<T> list) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return list;
        }
        if (this.mySegmentLimit == 0) {
            return Collections.emptyList();
        }
        if (this.mySegmentLimit > 0 && list.size() > this.mySegmentLimit) {
            LOGGER.warn("Template with more than " + this.mySegmentLimit + " segments had been build (" + list.size() + "). Text: " + this.myText);
            return list.subList(0, Math.min(list.size(), this.mySegmentLimit));
        }
        return list;
    }

    public void insertText(int offset, String text, boolean disableEndVariable) {
        if (disableEndVariable) {
            String varName = null;
            for (VarOccurence occurence : this.myVariableOccurrences) {
                if (!LiveTemplateBuilder.isEndVariable(occurence.myName) || occurence.myOffset != offset) continue;
                varName = occurence.myName;
                break;
            }
            if (varName != null) {
                for (Variable variable : this.myVariables) {
                    if (!varName.equals(variable.getName())) continue;
                    variable.setAlwaysStopAt(false);
                    variable.setDefaultValueString("\"\"");
                    break;
                }
            }
        }
        int delta = text.length();
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (occurence.myOffset <= offset && (disableEndVariable || occurence.myOffset != offset)) continue;
            occurence.myOffset += delta;
        }
        this.myText.insert(offset, text);
        this.updateMarkers(offset, text);
    }

    public int length() {
        return this.myText.length();
    }

    private void updateMarkers(int offset, String text) {
        for (Marker marker : this.myMarkers) {
            if (offset < marker.getStartOffset()) {
                marker.myStartOffset += text.length();
                continue;
            }
            if (offset > marker.getEndOffset()) continue;
            marker.myEndOffset += text.length();
        }
    }

    private String generateUniqueVarName(Set<String> existingNames, boolean end) {
        String prefix = end ? END_PREFIX : "VAR";
        int i = 0;
        while (this.myVarNames.contains(prefix + i) || existingNames.contains(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }

    public int insertTemplate(int offset, TemplateImpl template, Map<String, String> predefinedVarValues) {
        int endOffset;
        String varName;
        int i;
        this.myIsToReformat = this.myText.length() > 0 || template.isToReformat();
        this.removeEndVarAtOffset(offset);
        String text = template.getTemplateText();
        this.insertText(offset, text, false);
        HashMap newVarNames = new HashMap();
        HashSet oldVarNames = new HashSet();
        for (i = 0; i < template.getVariableCount(); ++i) {
            varName = template.getVariableNameAt(i);
            oldVarNames.add(varName);
        }
        for (i = 0; i < template.getVariableCount(); ++i) {
            String newVarName;
            varName = template.getVariableNameAt(i);
            if (TemplateImpl.INTERNAL_VARS_SET.contains(varName) || predefinedVarValues != null && predefinedVarValues.containsKey(varName)) continue;
            if (this.myVarNames.contains(varName)) {
                oldVarNames.remove(varName);
                newVarName = this.generateUniqueVarName((Set<String>)oldVarNames, LiveTemplateBuilder.isEndVariable(varName));
                newVarNames.put(varName, newVarName);
                if (varName.equals(this.myLastEndVarName)) {
                    this.myLastEndVarName = newVarName;
                }
            } else {
                newVarName = varName;
            }
            Variable var = new Variable(newVarName, template.getExpressionStringAt(i), template.getDefaultValueStringAt(i), template.isAlwaysStopAt(i));
            if (this.mySegmentLimit >= 0 && this.myVariables.size() >= this.mySegmentLimit) {
                if (this.mySegmentLimit <= 0) break;
                LOGGER.warn("Template with more than " + this.mySegmentLimit + " segments had been build. Text: " + this.myText);
                break;
            }
            this.myVariables.add(var);
            this.myVarNames.add(newVarName);
        }
        int end = -1;
        for (int i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            String segmentName = template.getSegmentName(i2);
            int localOffset = template.getSegmentOffset(i2);
            if ("END".equals(segmentName)) {
                end = offset + localOffset;
                continue;
            }
            if (predefinedVarValues != null && predefinedVarValues.containsKey(segmentName)) {
                String value = predefinedVarValues.get(segmentName);
                this.insertText(offset + localOffset, value, false);
                offset += value.length();
                continue;
            }
            if (newVarNames.containsKey(segmentName)) {
                segmentName = (String)newVarNames.get(segmentName);
            }
            this.myVariableOccurrences.add(new VarOccurence(segmentName, offset + localOffset));
        }
        int n = endOffset = end >= 0 ? end : offset + text.length();
        if (endOffset > 0 && endOffset != offset + text.length() && endOffset < this.myText.length() && !this.hasVarAtOffset(endOffset)) {
            this.myLastEndVarName = this.generateUniqueVarName(this.myVarNames, true);
            this.myVariables.add(new Variable(this.myLastEndVarName, "", "", true));
            this.myVarNames.add(this.myLastEndVarName);
            this.myVariableOccurrences.add(new VarOccurence(this.myLastEndVarName, endOffset));
        }
        return endOffset;
    }

    private void removeEndVarAtOffset(int offset) {
        Iterator<VarOccurence> it = this.myVariableOccurrences.iterator();
        while (it.hasNext()) {
            VarOccurence occurence = it.next();
            if (!LiveTemplateBuilder.isEndVariable(occurence.myName) || occurence.myOffset != offset) continue;
            it.remove();
            Iterator<Variable> it1 = this.myVariables.iterator();
            while (it1.hasNext()) {
                Variable variable = it1.next();
                if (!occurence.myName.equals(variable.getName())) continue;
                it1.remove();
            }
        }
    }

    private boolean hasVarAtOffset(int offset) {
        boolean flag = false;
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (occurence.myOffset != offset) continue;
            flag = true;
        }
        return flag;
    }

    public Marker createMarker(int offset) {
        Marker marker = new Marker(offset, offset);
        this.myMarkers.add(marker);
        return marker;
    }

    public static class Marker {
        int myStartOffset;
        int myEndOffset;

        private Marker(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }
    }

    private static class VarOccurence {
        String myName;
        int myOffset;

        private VarOccurence(String name, int offset) {
            this.myName = name;
            this.myOffset = offset;
        }
    }
}

