/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.PresentableActionHandlerBasedAction;
import com.intellij.lang.CodeInsightActions;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GotoSuperAction
extends PresentableActionHandlerBasedAction
implements CodeInsightActionHandler,
DumbAware {
    @NonNls
    public static final String FEATURE_ID = "navigation.goto.super";

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    public void invoke(final @NotNull Project project2, final @NotNull Editor editor, final @NotNull PsiFile file2) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        final CodeInsightActionHandler codeInsightActionHandler = (CodeInsightActionHandler)CodeInsightActions.GOTO_SUPER.forLanguage(language);
        if (codeInsightActionHandler != null) {
            DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    codeInsightActionHandler.invoke(project2, editor, file2);
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void update(AnActionEvent event) {
        if (CodeInsightActions.GOTO_SUPER.hasAnyExtensions()) {
            event.getPresentation().setVisible(true);
            super.update(event);
        } else {
            event.getPresentation().setVisible(false);
        }
    }

    @NotNull
    protected LanguageExtension<CodeInsightActionHandler> getLanguageExtension() {
        return CodeInsightActions.GOTO_SUPER;
    }
}

