/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        PsiElement sourceElement = queryParameters.getElement();
        if (sourceElement instanceof PsiMethod) {
            return MethodImplementationsSearch.processImplementations((PsiMethod)sourceElement, consumer, queryParameters.getScope());
        }
        return true;
    }

    public static boolean processImplementations(PsiMethod psiMethod, final Processor<PsiElement> consumer, SearchScope searchScope) {
        if (!FunctionalExpressionSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope).forEach((Processor)new Processor<PsiFunctionalExpression>(){

            public boolean process(PsiFunctionalExpression expression) {
                return consumer.process((Object)expression);
            }
        })) {
            return false;
        }
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        MethodImplementationsSearch.getOverridingMethods(psiMethod, methods, searchScope);
        return ContainerUtil.process(methods, consumer);
    }

    public static void getOverridingMethods(PsiMethod method, List<PsiMethod> list, SearchScope scope) {
        for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true)) {
            list.add(psiMethod);
        }
    }

    @Deprecated
    public static PsiMethod[] getMethodImplementations(PsiMethod method, SearchScope scope) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        MethodImplementationsSearch.getOverridingMethods(method, result, scope);
        return result.toArray(new PsiMethod[result.size()]);
    }
}

