/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class ClassImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        PsiElement sourceElement = queryParameters.getElement();
        return !(sourceElement instanceof PsiClass) || ClassImplementationsSearch.processImplementations((PsiClass)sourceElement, consumer, queryParameters.getScope());
    }

    public static boolean processImplementations(PsiClass psiClass, final Processor<PsiElement> processor2, SearchScope scope) {
        if (!FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)scope).forEach((Processor)new Processor<PsiFunctionalExpression>(){

            public boolean process(PsiFunctionalExpression expression) {
                return processor2.process((Object)expression);
            }
        })) {
            return false;
        }
        final boolean showInterfaces = Registry.is((String)"ide.goto.implementation.show.interfaces");
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass element) {
                if (!showInterfaces && element.isInterface()) {
                    return true;
                }
                return processor2.process((Object)element);
            }
        }));
    }
}

